/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.pdf.AbstractPdfDssDict;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleDssDict
extends AbstractPdfDssDict {
    private static final long serialVersionUID = -6209573303629371895L;
    private static final Logger LOG = LoggerFactory.getLogger(SingleDssDict.class);
    private final List<PdfVRIDict> vris;

    public static SingleDssDict extract(PdfDict documentDict) {
        PdfDict dssDict;
        if (documentDict != null && (dssDict = documentDict.getAsDict("DSS")) != null) {
            return new SingleDssDict(dssDict);
        }
        LOG.debug("No DSS dictionary found");
        return null;
    }

    protected SingleDssDict(PdfDict dssDictionary) {
        super(dssDictionary);
        this.vris = this.extractVRIs(dssDictionary);
    }

    private List<PdfVRIDict> extractVRIs(PdfDict dssDictionary) {
        block7: {
            PdfDict vriDict = dssDictionary.getAsDict("VRI");
            if (vriDict != null) {
                LOG.trace("There is a VRI dictionary in DSS dictionary");
                try {
                    Object[] names = vriDict.list();
                    if (Utils.isArrayNotEmpty((Object[])names)) {
                        ArrayList<PdfVRIDict> result = new ArrayList<PdfVRIDict>();
                        for (Object name : names) {
                            if (!this.isDictionaryKey((String)name)) continue;
                            result.add(new PdfVRIDict((String)name, vriDict.getAsDict((String)name)));
                        }
                        return result;
                    }
                }
                catch (Exception e) {
                    String errorMessage = "Unable to analyse VRI dictionary. Reason : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                        break block7;
                    }
                    LOG.warn(errorMessage, (Object)e.getMessage());
                }
            } else {
                LOG.trace("No VRI dictionary found in DSS dictionary");
            }
        }
        return Collections.emptyList();
    }

    private boolean isDictionaryKey(String name) {
        return DSSUtils.isSHA1Digest((String)name);
    }

    @Override
    protected String getDictionaryName() {
        return "DSS";
    }

    @Override
    protected String getCertArrayDictionaryName() {
        return "Certs";
    }

    @Override
    protected String getCRLArrayDictionaryName() {
        return "CRLs";
    }

    @Override
    protected String getOCSPArrayDictionaryName() {
        return "OCSPs";
    }

    @Override
    public List<PdfVRIDict> getVRIs() {
        return this.vris;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        if (this.vris != null) {
            result = 31 * result + this.vris.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleDssDict other = (SingleDssDict)obj;
        return !(this.vris == null ? other.vris != null : !this.vris.equals(other.vris));
    }
}

