/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.modifications;

import eu.europa.esig.dss.enumerations.PdfObjectModificationType;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.modifications.ObjectModification;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModifications;
import java.util.Collection;
import java.util.List;

public class PdfObjectModificationsFilter {
    public PdfObjectModifications filter(Collection<ObjectModification> objectModifications) {
        PdfObjectModifications pdfObjectModifications = new PdfObjectModifications();
        for (ObjectModification objectModification : objectModifications) {
            if (PdfObjectModificationsFilter.skipChange(objectModification)) continue;
            if (PdfObjectModificationsFilter.isExtensionChange(objectModification)) {
                pdfObjectModifications.addSecureChange(objectModification);
                continue;
            }
            if (PdfObjectModificationsFilter.isSignatureOrFormFillChange(objectModification)) {
                pdfObjectModifications.addFormFillInAndSignatureCreationChange(objectModification);
                continue;
            }
            if (PdfObjectModificationsFilter.isAnnotationCreationChange(objectModification)) {
                pdfObjectModifications.addAnnotCreationChange(objectModification);
                continue;
            }
            pdfObjectModifications.addUndefinedChange(objectModification);
        }
        return pdfObjectModifications;
    }

    private static boolean skipChange(ObjectModification objectModification) {
        String lastKey = objectModification.getObjectTree().getLastKey();
        if (PdfObjectModificationType.DELETION.equals((Object)objectModification.getActionType()) && "AP".equals(lastKey)) {
            return true;
        }
        if (PdfObjectModificationType.MODIFICATION.equals((Object)objectModification.getActionType()) && "F".equals(lastKey)) {
            return true;
        }
        if (PdfObjectModificationType.MODIFICATION.equals((Object)objectModification.getActionType()) && "Type".equals(lastKey)) {
            return true;
        }
        return PdfObjectModificationType.MODIFICATION.equals((Object)objectModification.getActionType()) && "ITXT".equals(lastKey);
    }

    private static boolean isExtensionChange(ObjectModification objectModification) {
        if (PdfObjectModificationsFilter.isDSSDictionaryChange(objectModification)) {
            return true;
        }
        if (PdfObjectModificationsFilter.isDocTimeStampAdded(objectModification)) {
            return true;
        }
        if (PdfObjectModificationsFilter.isDocumentExtension(objectModification)) {
            return true;
        }
        if (PdfObjectModificationsFilter.isCatalogVersionChange(objectModification)) {
            return true;
        }
        return PdfObjectModificationsFilter.isCatalogExtensionsChange(objectModification);
    }

    private static boolean isDSSDictionaryChange(ObjectModification objectModification) {
        List<String> keyChain = objectModification.getObjectTree().getKeyChain();
        for (String key : keyChain) {
            if (!"DSS".equals(key)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDocTimeStampAdded(ObjectModification objectModification) {
        String key = objectModification.getObjectTree().getLastKey();
        if (PdfObjectModificationsFilter.isAnnotsKey(key)) {
            Object addedObject = objectModification.getFinalObject();
            return addedObject instanceof PdfDict && PdfObjectModificationsFilter.isDocTimeStamp((PdfDict)addedObject);
        }
        return false;
    }

    private static boolean isDocTimeStamp(PdfDict pdfDict) {
        String type;
        PdfDict vDict = pdfDict.getAsDict("V");
        return vDict != null && "DocTimeStamp".equals(type = vDict.getNameValue("Type"));
    }

    private static boolean isDocumentExtension(ObjectModification objectModification) {
        String key = objectModification.getObjectTree().getLastKey();
        String parentKey = PdfObjectModificationsFilter.getParentKey(objectModification);
        return "Extensions".equals(key) && "Catalog".equals(parentKey);
    }

    private static boolean isSignatureOrFormFillChange(ObjectModification objectModification) {
        if (PdfObjectModificationsFilter.isFieldFilled(objectModification)) {
            return true;
        }
        if (PdfObjectModificationsFilter.isAnnotsFill(objectModification)) {
            return true;
        }
        if (PdfObjectModificationsFilter.isFieldAppearanceCreationChange(objectModification)) {
            return true;
        }
        if (PdfObjectModificationsFilter.isMetaDataChange(objectModification)) {
            return true;
        }
        if (PdfObjectModificationsFilter.isCatalogPieceInfoChange(objectModification)) {
            return true;
        }
        if (PdfObjectModificationsFilter.isCatalogPermsCreationChange(objectModification)) {
            return true;
        }
        if (PdfObjectModificationsFilter.isCatalogNamesChange(objectModification)) {
            return true;
        }
        if (PdfObjectModificationsFilter.isCatalogOutputIntentsChange(objectModification)) {
            return true;
        }
        if (PdfObjectModificationsFilter.isAcroFormDictionaryChange(objectModification)) {
            return true;
        }
        return PdfObjectModificationsFilter.isFontCreationChange(objectModification);
    }

    private static boolean isFieldFilled(ObjectModification objectModification) {
        String key = objectModification.getObjectTree().getLastKey();
        String parentKey = PdfObjectModificationsFilter.getParentKey(objectModification);
        if ("V".equals(key) && PdfObjectModificationsFilter.isAnnotsKey(parentKey)) {
            return true;
        }
        if (PdfObjectModificationsFilter.isAnnotsKey(key)) {
            Object addedObject = objectModification.getFinalObject();
            return addedObject instanceof PdfDict && PdfObjectModificationsFilter.isValueChange((PdfDict)addedObject);
        }
        return false;
    }

    private static boolean isValueChange(PdfDict pdfDict) {
        return pdfDict.getAsDict("V") != null;
    }

    private static boolean isAnnotsKey(String key) {
        return "Annots".equals(key) || "Fields".equals(key) || "Parent".equals(key);
    }

    private static boolean isAnnotsFill(ObjectModification objectModification) {
        String lastKey = objectModification.getObjectTree().getLastKey();
        String parentKey = PdfObjectModificationsFilter.getParentKey(objectModification);
        if (PdfObjectModificationsFilter.isAnnotsKey(lastKey) || PdfObjectModificationsFilter.isAnnotsKey(parentKey)) {
            return PdfObjectModificationType.MODIFICATION.equals((Object)objectModification.getActionType());
        }
        List<String> keyChain = objectModification.getObjectTree().getKeyChain();
        for (String key : keyChain) {
            if (!PdfObjectModificationType.CREATION.equals((Object)objectModification.getActionType()) || !PdfObjectModificationsFilter.isAnnotsKey(key)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFieldAppearanceCreationChange(ObjectModification objectModification) {
        boolean appearanceDictChangeFound = false;
        boolean annotChangeFound = false;
        if (PdfObjectModificationType.CREATION.equals((Object)objectModification.getActionType())) {
            for (String chainKey : objectModification.getObjectTree().getKeyChain()) {
                if (PdfObjectModificationsFilter.isAnnotsKey(chainKey)) {
                    annotChangeFound = true;
                    continue;
                }
                if (!"AP".equals(chainKey)) continue;
                appearanceDictChangeFound = true;
            }
        }
        return appearanceDictChangeFound && annotChangeFound;
    }

    private static boolean isCatalogVersionChange(ObjectModification objectModification) {
        String key = objectModification.getObjectTree().getLastKey();
        String parentKey = PdfObjectModificationsFilter.getParentKey(objectModification);
        return PdfObjectModificationType.MODIFICATION.equals((Object)objectModification.getActionType()) && "Version".equals(key) && "Catalog".equals(parentKey);
    }

    private static boolean isCatalogExtensionsChange(ObjectModification objectModification) {
        List<String> keyChain = objectModification.getObjectTree().getKeyChain();
        for (String key : keyChain) {
            if (!"Extensions".equals(key)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCatalogPieceInfoChange(ObjectModification objectModification) {
        List<String> keyChain = objectModification.getObjectTree().getKeyChain();
        for (String key : keyChain) {
            if (!"PieceInfo".equals(key)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCatalogPermsCreationChange(ObjectModification objectModification) {
        String key = objectModification.getObjectTree().getLastKey();
        return PdfObjectModificationType.CREATION.equals((Object)objectModification.getActionType()) && "Perms".equals(key);
    }

    private static boolean isCatalogNamesChange(ObjectModification objectModification) {
        List<String> keyChain = objectModification.getObjectTree().getKeyChain();
        for (String key : keyChain) {
            if (!"Names".equals(key)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCatalogOutputIntentsChange(ObjectModification objectModification) {
        String key = objectModification.getObjectTree().getLastKey();
        return PdfObjectModificationType.CREATION.equals((Object)objectModification.getActionType()) && "OutputIntents".equals(key);
    }

    private static boolean isMetaDataChange(ObjectModification objectModification) {
        String key = objectModification.getObjectTree().getLastKey();
        String parentKey = PdfObjectModificationsFilter.getParentKey(objectModification);
        return "Metadata".equals(key) || "Metadata".equals(parentKey);
    }

    private static boolean isAcroFormDictionaryChange(ObjectModification objectModification) {
        boolean containsAcroForm = false;
        boolean containsResourseDict = false;
        List<String> keyChain = objectModification.getObjectTree().getKeyChain();
        for (String key : keyChain) {
            if ("AcroForm".equals(key)) {
                containsAcroForm = true;
                continue;
            }
            if (!"DA".equals(key) && !"DR".equals(key) && !"SigFlags".equals(key)) continue;
            containsResourseDict = true;
        }
        return containsAcroForm && containsResourseDict;
    }

    private static boolean isFontCreationChange(ObjectModification objectModification) {
        String key = objectModification.getObjectTree().getLastKey();
        String parentKey = PdfObjectModificationsFilter.getParentKey(objectModification);
        return PdfObjectModificationType.CREATION.equals((Object)objectModification.getActionType()) && ("Font".equals(key) || "Font".equals(parentKey));
    }

    private static String getParentKey(ObjectModification objectModification) {
        List<String> keyChain = objectModification.getObjectTree().getKeyChain();
        if (keyChain.size() > 1) {
            return keyChain.get(keyChain.size() - 2);
        }
        return null;
    }

    private static boolean isAnnotationCreationChange(ObjectModification objectModification) {
        return PdfObjectModificationsFilter.isAnnotCreation(objectModification);
    }

    private static boolean isAnnotCreation(ObjectModification objectModification) {
        String lastKey = objectModification.getObjectTree().getLastKey();
        String parentKey = PdfObjectModificationsFilter.getParentKey(objectModification);
        return PdfObjectModificationsFilter.isAnnotsKey(lastKey) || PdfObjectModificationsFilter.isAnnotsKey(parentKey);
    }
}

