/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.modifications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PdfObjectTree {
    private static final String SLASH = "/";
    private static final String SPACE = " ";
    private static final String REFERENCE = " 0 R";
    private static final String STREAM = "stream";
    private List<String> keyChain;
    private List<Number> refChain;
    private StringBuilder sb;

    public PdfObjectTree(String key) {
        this.keyChain = new ArrayList<String>();
        this.refChain = new ArrayList<Number>();
        this.sb = new StringBuilder();
        this.addKey(key);
    }

    private PdfObjectTree(PdfObjectTree objectTree) {
        this.keyChain = new ArrayList<String>(objectTree.keyChain);
        this.refChain = new ArrayList<Number>(objectTree.refChain);
        this.sb = new StringBuilder(objectTree.sb.toString());
    }

    public PdfObjectTree copy() {
        return new PdfObjectTree(this);
    }

    public void addKey(String key) {
        this.keyChain.add(key);
        if (this.sb.length() != 0) {
            this.sb.append(SPACE);
        }
        this.sb.append(SLASH);
        this.sb.append(key);
    }

    public void addReference(Number objectNumber) {
        this.refChain.add(objectNumber);
        if (this.sb.length() != 0) {
            this.sb.append(SPACE);
        }
        this.sb.append(objectNumber);
        this.sb.append(REFERENCE);
    }

    public void setStream() {
        if (this.sb.length() != 0) {
            this.sb.append(SPACE);
        }
        this.sb.append(STREAM);
    }

    public List<String> getKeyChain() {
        return this.keyChain;
    }

    public int getChainDeepness() {
        return this.keyChain.size();
    }

    public String getLastKey() {
        return this.keyChain.get(this.keyChain.size() - 1);
    }

    public boolean isProcessedReference(Number objectNumber) {
        return this.refChain.contains(objectNumber);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PdfObjectTree)) {
            return false;
        }
        PdfObjectTree that = (PdfObjectTree)o;
        if (!Objects.equals(this.keyChain, that.keyChain)) {
            return false;
        }
        if (!Objects.equals(this.refChain, that.refChain)) {
            return false;
        }
        return Objects.equals(this.sb.toString(), that.sb.toString());
    }

    public int hashCode() {
        int result = this.keyChain != null ? this.keyChain.hashCode() : 0;
        result = 31 * result + (this.refChain != null ? this.refChain.hashCode() : 0);
        result = 31 * result + (this.sb != null ? this.sb.toString().hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.sb.toString();
    }
}

