/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineT;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PDFDocumentValidator;
import eu.europa.esig.dss.pdf.DSSDictionaryCallback;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PdfObjFactory;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.tsp.TSPSource;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class PAdESLevelBaselineLT
implements SignatureExtension<PAdESSignatureParameters> {
    private final CertificateVerifier certificateVerifier;
    private final TSPSource tspSource;

    PAdESLevelBaselineLT(TSPSource tspSource, CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
        this.tspSource = tspSource;
    }

    public InMemoryDocument extendSignatures(DSSDocument document, PAdESSignatureParameters parameters) throws DSSException {
        PDFDocumentValidator pdfDocumentValidator = new PDFDocumentValidator(document);
        pdfDocumentValidator.setCertificateVerifier(this.certificateVerifier);
        List<AdvancedSignature> signatures = pdfDocumentValidator.getSignatures();
        for (AdvancedSignature advancedSignature : signatures) {
            if (advancedSignature.isDataForSignatureLevelPresent(SignatureLevel.PAdES_BASELINE_T)) continue;
            PAdESLevelBaselineT padesLevelBaselineT = new PAdESLevelBaselineT(this.tspSource);
            document = padesLevelBaselineT.extendSignatures(document, parameters);
            pdfDocumentValidator = new PDFDocumentValidator(document);
            pdfDocumentValidator.setCertificateVerifier(this.certificateVerifier);
            break;
        }
        signatures = pdfDocumentValidator.getSignatures();
        ArrayList<DSSDictionaryCallback> callbacks = new ArrayList<DSSDictionaryCallback>();
        for (AdvancedSignature signature : signatures) {
            if (!(signature instanceof PAdESSignature)) continue;
            callbacks.add(this.validate((PAdESSignature)signature));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PDFSignatureService signatureService = PdfObjFactory.getInstance().newPAdESSignatureService();
        signatureService.addDssDictionary(document.openStream(), byteArrayOutputStream, callbacks);
        InMemoryDocument inMemoryDocument = new InMemoryDocument(byteArrayOutputStream.toByteArray());
        inMemoryDocument.setMimeType(MimeType.PDF);
        return inMemoryDocument;
    }

    private DSSDictionaryCallback validate(PAdESSignature signature) {
        ValidationContext validationContext = signature.getSignatureValidationContext(this.certificateVerifier);
        DefaultAdvancedSignature.RevocationDataForInclusion revocationsForInclusionInProfileLT = signature.getRevocationDataForInclusion(validationContext);
        DSSDictionaryCallback validationCallback = new DSSDictionaryCallback();
        validationCallback.setSignature(signature);
        validationCallback.setCrls(revocationsForInclusionInProfileLT.crlTokens);
        validationCallback.setOcsps(revocationsForInclusionInProfileLT.ocspTokens);
        HashSet<CertificateToken> certs = new HashSet<CertificateToken>(signature.getCertificates());
        validationCallback.setCertificates(certs);
        return validationCallback;
    }
}

