/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pdf.PDFTimestampService;
import eu.europa.esig.dss.pdf.PdfObjFactory;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.x509.tsp.TSPSource;
import java.io.ByteArrayOutputStream;

class PAdESLevelBaselineT
implements SignatureExtension<PAdESSignatureParameters> {
    private final TSPSource tspSource;

    public PAdESLevelBaselineT(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    public DSSDocument extendSignatures(DSSDocument document, PAdESSignatureParameters params) throws DSSException {
        PdfObjFactory factory = PdfObjFactory.getInstance();
        ByteArrayOutputStream tDoc = new ByteArrayOutputStream();
        PDFTimestampService timestampService = factory.newTimestampSignatureService();
        timestampService.timestamp(document, tDoc, params, this.tspSource);
        InMemoryDocument inMemoryDocument = new InMemoryDocument(tDoc.toByteArray());
        inMemoryDocument.setMimeType(MimeType.PDF);
        return inMemoryDocument;
    }
}

