/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.SigningOperation;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineT;
import eu.europa.esig.dss.cades.signature.CustomContentSigner;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineLT;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineLTA;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineT;
import eu.europa.esig.dss.pades.signature.PadesCMSSignedDataBuilder;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PdfObjFactory;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESService
extends AbstractSignatureService<PAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESService.class);
    private final PadesCMSSignedDataBuilder padesCMSSignedDataBuilder;

    public PAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        this.padesCMSSignedDataBuilder = new PadesCMSSignedDataBuilder(certificateVerifier);
        LOG.debug("+ PAdESService created");
    }

    private SignatureExtension<PAdESSignatureParameters> getExtensionProfile(SignatureLevel signatureLevel) {
        switch (signatureLevel) {
            case PAdES_BASELINE_B: {
                return null;
            }
            case PAdES_BASELINE_T: {
                return new PAdESLevelBaselineT(this.tspSource);
            }
            case PAdES_BASELINE_LT: {
                return new PAdESLevelBaselineLT(this.tspSource, this.certificateVerifier);
            }
            case PAdES_BASELINE_LTA: {
                return new PAdESLevelBaselineLTA(this.tspSource, this.certificateVerifier);
            }
        }
        throw new IllegalArgumentException("Signature format '" + signatureLevel + "' not supported");
    }

    public ToBeSigned getDataToSign(DSSDocument toSignDocument, PAdESSignatureParameters parameters) throws DSSException {
        this.assertSigningDateInCertificateValidityRange((AbstractSignatureParameters)parameters);
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId());
        PDFSignatureService pdfSignatureService = PdfObjFactory.getInstance().newPAdESSignatureService();
        InputStream inputStream = toSignDocument.openStream();
        byte[] messageDigest = pdfSignatureService.digest(inputStream, parameters, parameters.getDigestAlgorithm());
        Utils.closeQuietly((Closeable)inputStream);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = this.padesCMSSignedDataBuilder.getSignerInfoGeneratorBuilder(parameters, messageDigest);
        CMSSignedDataGenerator generator = this.padesCMSSignedDataBuilder.createCMSSignedDataGenerator(parameters, (ContentSigner)customContentSigner, signerInfoGeneratorBuilder, null);
        CMSProcessableByteArray content = new CMSProcessableByteArray(messageDigest);
        CMSUtils.generateDetachedCMSSignedData((CMSSignedDataGenerator)generator, (CMSProcessableByteArray)content);
        byte[] dataToSign = customContentSigner.getOutputStream().toByteArray();
        return new ToBeSigned(dataToSign);
    }

    public DSSDocument signDocument(DSSDocument toSignDocument, PAdESSignatureParameters parameters, SignatureValue signatureValue) throws DSSException {
        this.assertSigningDateInCertificateValidityRange((AbstractSignatureParameters)parameters);
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId(), signatureValue.getValue());
        PDFSignatureService pdfSignatureService = PdfObjFactory.getInstance().newPAdESSignatureService();
        InputStream inputStream = toSignDocument.openStream();
        byte[] messageDigest = pdfSignatureService.digest(inputStream, parameters, parameters.getDigestAlgorithm());
        Utils.closeQuietly((Closeable)inputStream);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = this.padesCMSSignedDataBuilder.getSignerInfoGeneratorBuilder(parameters, messageDigest);
        CMSSignedDataGenerator generator = this.padesCMSSignedDataBuilder.createCMSSignedDataGenerator(parameters, (ContentSigner)customContentSigner, signerInfoGeneratorBuilder, null);
        CMSProcessableByteArray content = new CMSProcessableByteArray(messageDigest);
        CMSSignedData data = CMSUtils.generateDetachedCMSSignedData((CMSSignedDataGenerator)generator, (CMSProcessableByteArray)content);
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        if (signatureLevel != SignatureLevel.PAdES_BASELINE_B) {
            CAdESLevelBaselineT cadesLevelBaselineT = new CAdESLevelBaselineT(this.tspSource, false);
            data = cadesLevelBaselineT.extendCMSSignatures(data, (CAdESSignatureParameters)parameters);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] encodedData = CMSUtils.getEncoded((CMSSignedData)data);
        inputStream = toSignDocument.openStream();
        pdfSignatureService.sign(inputStream, encodedData, byteArrayOutputStream, parameters, parameters.getDigestAlgorithm());
        Utils.closeQuietly((Closeable)inputStream);
        InMemoryDocument signature = new InMemoryDocument(byteArrayOutputStream.toByteArray());
        signature.setMimeType(MimeType.PDF);
        SignatureExtension<PAdESSignatureParameters> extension = this.getExtensionProfile(signatureLevel);
        if (signatureLevel != SignatureLevel.PAdES_BASELINE_B && signatureLevel != SignatureLevel.PAdES_BASELINE_T && extension != null) {
            signature = extension.extendSignatures((DSSDocument)signature, (AbstractSignatureParameters)parameters);
        }
        parameters.reinitDeterministicId();
        signature.setName(DSSUtils.getFinalFileName((DSSDocument)toSignDocument, (SigningOperation)SigningOperation.SIGN, (SignatureLevel)parameters.getSignatureLevel()));
        return signature;
    }

    public DSSDocument extendDocument(DSSDocument original, PAdESSignatureParameters parameters) throws DSSException {
        SignatureExtension<PAdESSignatureParameters> extension = this.getExtensionProfile(parameters.getSignatureLevel());
        if (extension != null) {
            DSSDocument extended = extension.extendSignatures(original, (AbstractSignatureParameters)parameters);
            extended.setName(DSSUtils.getFinalFileName((DSSDocument)original, (SigningOperation)SigningOperation.EXTEND, (SignatureLevel)parameters.getSignatureLevel()));
            return extended;
        }
        return original;
    }

    public List<String> getAvailableSignatureFields(DSSDocument document) {
        PDFSignatureService pdfSignatureService = PdfObjFactory.getInstance().newPAdESSignatureService();
        return pdfSignatureService.getAvailableSignatureFields(document);
    }

    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters) {
        PDFSignatureService pdfSignatureService = PdfObjFactory.getInstance().newPAdESSignatureService();
        return pdfSignatureService.addNewSignatureField(document, parameters);
    }
}

