/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature.visible;

import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pades.signature.visible.ImageUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageTextWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ImageTextWriter.class);
    private static final int DEFAULT_MARGIN = 10;
    public static final int PDF_DEFAULT_DPI = 72;

    private ImageTextWriter() {
    }

    public static BufferedImage createTextImage(String text, Font font, Color textColor, Color bgColor, int dpi, SignatureImageTextParameters.SignerTextHorizontalAlignment horizontalAlignment) {
        float fontSize = Math.round((float)(font.getSize() * dpi) / 72.0f);
        Font largerFont = font.deriveFont(fontSize);
        Dimension dimension = ImageTextWriter.computeSize(largerFont, text);
        return ImageTextWriter.createTextImage(text, largerFont, textColor, bgColor, dimension.width, dimension.height, horizontalAlignment);
    }

    public static Dimension computeSize(Font font, String text) {
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics g = img.getGraphics();
        g.setFont(font);
        FontMetrics fontMetrics = g.getFontMetrics(font);
        String[] lines = text.split("\n");
        int width = 0;
        for (String line : lines) {
            int lineWidth = fontMetrics.stringWidth(line);
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        int height = fontMetrics.getHeight() * lines.length + 10;
        g.dispose();
        return new Dimension(width += 10, height);
    }

    private static BufferedImage createTextImage(String text, Font font, Color textColor, Color bgColor, int width, int height, SignatureImageTextParameters.SignerTextHorizontalAlignment horizontalAlignment) {
        int imageType;
        String[] lines = text.split("\n");
        if (ImageTextWriter.isTransparent(textColor, bgColor)) {
            LOG.warn("Transparency detected and enabled (be careful not valid with PDF/A !)");
            imageType = 2;
        } else {
            imageType = 1;
        }
        BufferedImage img = new BufferedImage(width, height, imageType);
        Graphics2D g = img.createGraphics();
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics(font);
        ImageUtils.initRendering(g);
        if (bgColor == null) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(bgColor);
        }
        g.fillRect(0, 0, width, height);
        if (textColor == null) {
            g.setPaint(Color.BLACK);
        } else {
            g.setPaint(textColor);
        }
        int lineHeight = fm.getHeight();
        int y = fm.getMaxAscent() + 5;
        for (String line : lines) {
            int x = 5;
            if (horizontalAlignment != null) {
                switch (horizontalAlignment) {
                    case RIGHT: {
                        x = (img.getWidth() - fm.stringWidth(line)) / 2;
                        break;
                    }
                    case CENTER: {
                        x = img.getWidth() / 2 - fm.stringWidth(line) / 2;
                        break;
                    }
                }
            }
            g.drawString(line, x, y);
            y += lineHeight;
        }
        g.dispose();
        return img;
    }

    private static boolean isTransparent(Color ... colors) {
        if (colors != null) {
            for (Color color : colors) {
                int alpha = color.getAlpha();
                if (alpha >= 255) continue;
                return true;
            }
        }
        return false;
    }
}

