/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature.visible;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pades.signature.visible.ImageAndResolution;
import eu.europa.esig.dss.pades.signature.visible.ImageTextWriter;
import eu.europa.esig.dss.pades.signature.visible.ImagesMerger;
import eu.europa.esig.dss.utils.Utils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ImageUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ImageUtils.class);
    private static final int DPI = 300;
    private static final int[] IMAGE_TRANSPARENT_TYPES;

    private ImageUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageAndResolution create(SignatureImageParameters imageParameters) throws IOException {
        SignatureImageTextParameters textParamaters = imageParameters.getTextParameters();
        DSSDocument image = imageParameters.getImage();
        if (textParamaters == null) return ImageUtils.readAndDisplayMetadata(image);
        if (!Utils.isStringNotEmpty((String)textParamaters.getText())) return ImageUtils.readAndDisplayMetadata(image);
        BufferedImage buffImg = ImageTextWriter.createTextImage(textParamaters.getText(), textParamaters.getFont(), textParamaters.getTextColor(), textParamaters.getBackgroundColor(), ImageUtils.getDpi(imageParameters.getDpi()), textParamaters.getSignerTextHorizontalAlignment());
        if (image == null) return ImageUtils.convertToInputStream(buffImg, ImageUtils.getDpi(imageParameters.getDpi()));
        try (InputStream is = image.openStream();){
            if (is == null) return ImageUtils.convertToInputStream(buffImg, ImageUtils.getDpi(imageParameters.getDpi()));
            switch (textParamaters.getSignerNamePosition()) {
                case LEFT: {
                    buffImg = ImagesMerger.mergeOnRight(ImageIO.read(is), buffImg, textParamaters.getBackgroundColor(), imageParameters.getSignerTextImageVerticalAlignment());
                    return ImageUtils.convertToInputStream(buffImg, ImageUtils.getDpi(imageParameters.getDpi()));
                }
                case RIGHT: {
                    buffImg = ImagesMerger.mergeOnRight(buffImg, ImageIO.read(is), textParamaters.getBackgroundColor(), imageParameters.getSignerTextImageVerticalAlignment());
                    return ImageUtils.convertToInputStream(buffImg, ImageUtils.getDpi(imageParameters.getDpi()));
                }
                case TOP: {
                    buffImg = ImagesMerger.mergeOnTop(ImageIO.read(is), buffImg, textParamaters.getBackgroundColor());
                    return ImageUtils.convertToInputStream(buffImg, ImageUtils.getDpi(imageParameters.getDpi()));
                }
                case BOTTOM: {
                    buffImg = ImagesMerger.mergeOnTop(buffImg, ImageIO.read(is), textParamaters.getBackgroundColor());
                    return ImageUtils.convertToInputStream(buffImg, ImageUtils.getDpi(imageParameters.getDpi()));
                }
            }
            return ImageUtils.convertToInputStream(buffImg, ImageUtils.getDpi(imageParameters.getDpi()));
        }
    }

    static Dimension getOptimalSize(SignatureImageParameters imageParameters) throws IOException {
        SignatureImageTextParameters textParamaters;
        int width = 0;
        int height = 0;
        DSSDocument docImage = imageParameters.getImage();
        if (docImage != null) {
            BufferedImage image = ImageIO.read(docImage.openStream());
            width = image.getWidth();
            height = image.getHeight();
        }
        if ((textParamaters = imageParameters.getTextParameters()) != null && !textParamaters.getText().isEmpty()) {
            Dimension textDimension = ImageUtils.getTextDimension(textParamaters.getText(), textParamaters.getFont(), imageParameters.getDpi());
            switch (textParamaters.getSignerNamePosition()) {
                case LEFT: 
                case RIGHT: {
                    width += textDimension.width;
                    height = Math.max(height, textDimension.height);
                    break;
                }
                case TOP: 
                case BOTTOM: {
                    width = Math.max(width, textDimension.width);
                    height += textDimension.height;
                    break;
                }
            }
        }
        float ration = ImageUtils.getRation(imageParameters.getDpi());
        return new Dimension(Math.round((float)width / ration), Math.round((float)height / ration));
    }

    private static ImageAndResolution readAndDisplayMetadata(DSSDocument image) throws IOException {
        if (ImageUtils.isImageWithContentType(image, MimeType.JPEG)) {
            return ImageUtils.readAndDisplayMetadataJPEG(image);
        }
        if (ImageUtils.isImageWithContentType(image, MimeType.PNG)) {
            return ImageUtils.readAndDisplayMetadataPNG(image);
        }
        throw new DSSException("Unsupported image type");
    }

    private static boolean isImageWithContentType(DSSDocument image, MimeType expectedContentType) {
        if (image.getMimeType() != null) {
            return expectedContentType == image.getMimeType();
        }
        String contentType = null;
        try {
            contentType = Files.probeContentType(Paths.get(image.getName(), new String[0]));
        }
        catch (IOException e) {
            LOG.warn("Unable to retrieve the content-type : " + e.getMessage());
        }
        return Utils.areStringsEqual((String)expectedContentType.getMimeTypeString(), (String)contentType);
    }

    /*
     * Exception decompiling
     */
    private static ImageAndResolution readAndDisplayMetadataJPEG(DSSDocument image) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static ImageAndResolution readAndDisplayMetadataPNG(DSSDocument image) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Dimension getTextDimension(String text, Font font, Integer dpi) {
        float fontSize = Math.round((float)(font.getSize() * ImageUtils.getDpi(dpi)) / 72.0f);
        Font largerFont = font.deriveFont(fontSize);
        return ImageTextWriter.computeSize(largerFont, text);
    }

    private static ImageAndResolution convertToInputStream(BufferedImage buffImage, int dpi) throws IOException {
        if (ImageUtils.isTransparent(buffImage)) {
            return ImageUtils.convertToInputStreamPNG(buffImage, dpi);
        }
        return ImageUtils.convertToInputStreamJPG(buffImage, dpi);
    }

    private static ImageAndResolution convertToInputStreamJPG(BufferedImage buffImage, int dpi) throws IOException {
        ImageWriter writer = ImageUtils.getImageWriter("jpeg");
        JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)writer.getDefaultWriteParam();
        jpegParams.setCompressionMode(2);
        jpegParams.setCompressionQuality(1.0f);
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, jpegParams);
        ImageUtils.initDpiJPG(metadata, dpi);
        return ImageUtils.getImageAndResolution(buffImage, dpi, writer, jpegParams, metadata);
    }

    private static void initDpiJPG(IIOMetadata metadata, int dpi) throws IIOInvalidTreeException {
        Element tree = (Element)metadata.getAsTree("javax_imageio_jpeg_image_1.0");
        Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
        jfif.setAttribute("Xdensity", Integer.toString(dpi));
        jfif.setAttribute("Ydensity", Integer.toString(dpi));
        jfif.setAttribute("resUnits", "1");
        metadata.setFromTree("javax_imageio_jpeg_image_1.0", tree);
    }

    private static ImageAndResolution convertToInputStreamPNG(BufferedImage buffImage, int dpi) throws IOException {
        ImageWriter writer = ImageUtils.getImageWriter("png");
        ImageWriteParam imageWriterParams = writer.getDefaultWriteParam();
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(2);
        IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, imageWriterParams);
        ImageUtils.initDpiPNG(metadata, dpi);
        return ImageUtils.getImageAndResolution(buffImage, dpi, writer, imageWriterParams, metadata);
    }

    /*
     * Exception decompiling
     */
    private static ImageAndResolution getImageAndResolution(BufferedImage buffImage, int dpi, ImageWriter writer, ImageWriteParam imageWriterParams, IIOMetadata metadata) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void initDpiPNG(IIOMetadata metadata, int dpi) throws IIOInvalidTreeException {
        double dotsPerMilli = 1.0 * (double)dpi / 25.4;
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    static int getDpi(Integer dpi) {
        int result = 300;
        if (dpi != null && dpi > 0) {
            result = dpi;
        }
        return result;
    }

    private static float getRation(Integer dpi) {
        float floatDpi = ImageUtils.getDpi(dpi);
        return floatDpi / 72.0f;
    }

    public static boolean isTransparent(BufferedImage bufferedImage) {
        int type = bufferedImage.getType();
        return Arrays.binarySearch(IMAGE_TRANSPARENT_TYPES, type) > -1;
    }

    public static void initRendering(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
    }

    public static BufferedImage rotate(BufferedImage image, double angle) {
        double sin = Math.abs(Math.sin(Math.toRadians(angle)));
        double cos = Math.abs(Math.cos(Math.toRadians(angle)));
        int w = image.getWidth();
        int h = image.getHeight();
        int neww = (int)Math.floor((double)w * cos + (double)h * sin);
        int newh = (int)Math.floor((double)h * cos + (double)w * sin);
        BufferedImage result = new BufferedImage(neww, newh, image.getType());
        Graphics2D g = result.createGraphics();
        g.translate((neww - w) / 2, (newh - h) / 2);
        g.rotate(Math.toRadians(angle), w / 2, h / 2);
        g.drawRenderedImage(image, null);
        g.dispose();
        return result;
    }

    private static ImageWriter getImageWriter(String type) {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(type);
        if (!writers.hasNext()) {
            throw new DSSException("No writer for '" + type + "' found");
        }
        return writers.next();
    }

    private static ImageReader getImageReader(String type) {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(type);
        if (!readers.hasNext()) {
            throw new DSSException("No reader for '" + type + "' found");
        }
        return readers.next();
    }

    static {
        int[] imageAlphaTypes = new int[]{6, 7, 2, 3};
        Arrays.sort(imageAlphaTypes);
        IMAGE_TRANSPARENT_TYPES = imageAlphaTypes;
    }
}

