/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature.visible;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.signature.visible.ImageUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImagesMerger {
    private static final Logger LOG = LoggerFactory.getLogger(ImagesMerger.class);

    private ImagesMerger() {
    }

    public static BufferedImage mergeOnTop(BufferedImage bottom, BufferedImage top, Color bgColor) {
        if (bottom == null) {
            return top;
        }
        if (top == null) {
            return bottom;
        }
        int newImageWidth = Math.max(bottom.getWidth(), top.getWidth());
        int newImageHeigth = bottom.getHeight() + top.getHeight();
        int imageType = ImagesMerger.getImageType(bottom, top);
        BufferedImage combined = new BufferedImage(newImageWidth, newImageHeigth, imageType);
        Graphics2D g = combined.createGraphics();
        ImageUtils.initRendering(g);
        ImagesMerger.fillBackground(g, newImageWidth, newImageHeigth, bgColor);
        g.drawImage(top, (newImageWidth - top.getWidth()) / 2, 0, top.getWidth(), top.getHeight(), null);
        g.drawImage(bottom, (newImageWidth - bottom.getWidth()) / 2, top.getHeight(), bottom.getWidth(), bottom.getHeight(), null);
        return combined;
    }

    public static BufferedImage mergeOnRight(BufferedImage left, BufferedImage right, Color bgColor, SignatureImageParameters.SignerTextImageVerticalAlignment imageVerticalAlignment) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        int newImageWidth = left.getWidth() + right.getWidth();
        int newImageHeigth = Math.max(left.getHeight(), right.getHeight());
        int imageType = ImagesMerger.getImageType(left, right);
        BufferedImage combined = new BufferedImage(newImageWidth, newImageHeigth, imageType);
        Graphics2D g = combined.createGraphics();
        ImageUtils.initRendering(g);
        ImagesMerger.fillBackground(g, newImageWidth, newImageHeigth, bgColor);
        switch (imageVerticalAlignment) {
            case TOP: {
                g.drawImage(left, 0, 0, left.getWidth(), left.getHeight(), null);
                g.drawImage(right, left.getWidth(), 0, right.getWidth(), right.getHeight(), null);
                break;
            }
            case MIDDLE: {
                g.drawImage(left, 0, (newImageHeigth - left.getHeight()) / 2, left.getWidth(), left.getHeight(), null);
                g.drawImage(right, left.getWidth(), (newImageHeigth - right.getHeight()) / 2, right.getWidth(), right.getHeight(), null);
                break;
            }
            case BOTTOM: {
                if (left.getHeight() > right.getHeight()) {
                    g.drawImage(left, 0, 0, left.getWidth(), left.getHeight(), null);
                    g.drawImage(right, left.getWidth(), newImageHeigth - right.getHeight(), right.getWidth(), right.getHeight(), null);
                    break;
                }
                g.drawImage(left, 0, newImageHeigth - left.getHeight(), left.getWidth(), left.getHeight(), null);
                g.drawImage(right, left.getWidth(), 0, right.getWidth(), right.getHeight(), null);
                break;
            }
            default: {
                throw new DSSException("Unsupported SignerTextImageVerticalAlignment : " + (Object)((Object)imageVerticalAlignment));
            }
        }
        return combined;
    }

    private static void fillBackground(Graphics g, int width, int heigth, Color bgColor) {
        g.setColor(bgColor);
        g.fillRect(0, 0, width, heigth);
    }

    private static int getImageType(BufferedImage image1, BufferedImage image2) {
        int imageType = 1;
        if (ImageUtils.isTransparent(image1) || ImageUtils.isTransparent(image2)) {
            LOG.warn("Transparency detected and enabled (be careful not valid with PDF/A !)");
            imageType = 2;
        }
        return imageType;
    }
}

