/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.validation.CAdESCertificateSource;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bouncycastle.cms.CMSSignedData;

public class PAdESCertificateSource
extends CAdESCertificateSource {
    private List<CertificateToken> certificationFromDSSDict;

    public PAdESCertificateSource(PdfDssDict dssCatalog, CMSSignedData cmsSignedData, CertificatePool certPool) {
        super(cmsSignedData, certPool);
        this.extractFromDSSDict(dssCatalog);
    }

    private void extractFromDSSDict(PdfDssDict dssCatalog) {
        ArrayList<CertificateToken> certificationFromDSSDict = new ArrayList<CertificateToken>();
        if (dssCatalog != null) {
            Set<CertificateToken> certList = dssCatalog.getCertList();
            for (CertificateToken certToken : certList) {
                CertificateToken addedCertificate = this.addCertificate(certToken);
                if (certificationFromDSSDict.contains(addedCertificate)) continue;
                certificationFromDSSDict.add(addedCertificate);
            }
        }
    }

    public List<CertificateToken> getCertificationFromDSSDict() {
        return this.certificationFromDSSDict;
    }
}

