/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.SignatureForm;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.pades.validation.PAdESCRLSource;
import eu.europa.esig.dss.pades.validation.PAdESCertificateSource;
import eu.europa.esig.dss.pades.validation.PAdESOCSPSource;
import eu.europa.esig.dss.pdf.PdfDocTimestampInfo;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSignatureInfo;
import eu.europa.esig.dss.pdf.PdfSignatureOrDocTimestampInfo;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CRLRef;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.CertifiedRole;
import eu.europa.esig.dss.validation.OCSPRef;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.TimestampReference;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.validation.TimestampedObjectType;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.x509.crl.OfflineCRLSource;
import eu.europa.esig.dss.x509.ocsp.OfflineOCSPSource;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESSignature
extends CAdESSignature {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESSignature.class);
    private final DSSDocument document;
    private final PdfDssDict dssDictionary;
    private final PdfSignatureInfo pdfSignatureInfo;
    private PAdESCertificateSource padesCertSources;

    protected PAdESSignature(DSSDocument document, PdfSignatureInfo pdfSignatureInfo, CertificatePool certPool) throws DSSException {
        super(pdfSignatureInfo.getCades().getCmsSignedData(), certPool, pdfSignatureInfo.getCades().getDetachedContents());
        this.document = document;
        this.dssDictionary = pdfSignatureInfo.getDssDictionary();
        this.pdfSignatureInfo = pdfSignatureInfo;
    }

    public SignatureForm getSignatureForm() {
        return SignatureForm.PAdES;
    }

    public PAdESCertificateSource getCertificateSource() {
        if (this.padesCertSources == null) {
            this.padesCertSources = new PAdESCertificateSource(this.dssDictionary, super.getCmsSignedData(), this.certPool);
        }
        return this.padesCertSources;
    }

    public OfflineCRLSource getCRLSource() {
        if (this.offlineCRLSource == null) {
            this.offlineCRLSource = new PAdESCRLSource(this.dssDictionary);
        }
        return this.offlineCRLSource;
    }

    public OfflineOCSPSource getOCSPSource() {
        if (this.offlineOCSPSource == null) {
            this.offlineOCSPSource = new PAdESOCSPSource(this.dssDictionary);
        }
        return this.offlineOCSPSource;
    }

    public Date getSigningTime() {
        return this.pdfSignatureInfo.getSigningDate();
    }

    public SignatureProductionPlace getSignatureProductionPlace() {
        String location = this.pdfSignatureInfo.getLocation();
        if (Utils.isStringBlank((String)location)) {
            return super.getSignatureProductionPlace();
        }
        SignatureProductionPlace signatureProductionPlace = new SignatureProductionPlace();
        signatureProductionPlace.setCountryName(location);
        return signatureProductionPlace;
    }

    public String getContentType() {
        return MimeType.PDF.getMimeTypeString();
    }

    public String getContentIdentifier() {
        return null;
    }

    public String getContentHints() {
        return null;
    }

    public List<CertifiedRole> getCertifiedSignerRoles() {
        return null;
    }

    public List<TimestampToken> getSignatureTimestamps() {
        ArrayList<TimestampToken> result = new ArrayList<TimestampToken>();
        result.addAll(super.getSignatureTimestamps());
        Set<PdfSignatureOrDocTimestampInfo> outerSignatures = this.pdfSignatureInfo.getOuterSignatures();
        for (PdfSignatureOrDocTimestampInfo outerSignature : outerSignatures) {
            PdfDocTimestampInfo pdfBoxTimestampInfo;
            TimestampToken timestampToken;
            if (!outerSignature.isTimestamp() || !(outerSignature instanceof PdfDocTimestampInfo) || (timestampToken = (pdfBoxTimestampInfo = (PdfDocTimestampInfo)outerSignature).getTimestampToken()).getTimeStampType() != TimestampType.SIGNATURE_TIMESTAMP) continue;
            timestampToken.setTimestampedReferences(this.getSignatureTimestampedReferences());
            result.add(timestampToken);
        }
        return Collections.unmodifiableList(result);
    }

    public List<TimestampToken> getTimestampsX1() {
        return Collections.emptyList();
    }

    public List<TimestampToken> getTimestampsX2() {
        return Collections.emptyList();
    }

    public List<TimestampToken> getArchiveTimestamps() {
        ArrayList<TimestampToken> archiveTimestampTokenList = new ArrayList<TimestampToken>();
        ArrayList<String> timestampedTimestamps = new ArrayList<String>();
        Set<PdfSignatureOrDocTimestampInfo> outerSignatures = this.pdfSignatureInfo.getOuterSignatures();
        this.usedCertificatesDigestAlgorithms.add(DigestAlgorithm.SHA1);
        for (TimestampToken token : super.getSignatureTimestamps()) {
            timestampedTimestamps.add(token.getDSSIdAsString());
        }
        for (PdfSignatureOrDocTimestampInfo outerSignature : outerSignatures) {
            if (!outerSignature.isTimestamp()) continue;
            PdfDocTimestampInfo pdfBoxTimestampInfo = (PdfDocTimestampInfo)outerSignature;
            TimestampToken timestampToken = pdfBoxTimestampInfo.getTimestampToken();
            if (timestampToken.getTimeStampType() == TimestampType.ARCHIVE_TIMESTAMP) {
                List<TimestampReference> references = this.getSignatureTimestampedReferences();
                for (String timestampId : timestampedTimestamps) {
                    references.add(new TimestampReference(timestampId, TimestampedObjectType.TIMESTAMP));
                }
                List<CertificateRef> certRefs = this.getCertificateRefs();
                for (CertificateRef certRef : certRefs) {
                    references.add(this.createCertificateTimestampReference(certRef));
                }
                this.addReferencesFromOfflineCRLSource(references);
                this.addReferencesFromOfflineOCSPSource(references);
                timestampToken.setTimestampedReferences(references);
                archiveTimestampTokenList.add(timestampToken);
            }
            timestampedTimestamps.add(timestampToken.getDSSIdAsString());
        }
        return Collections.unmodifiableList(archiveTimestampTokenList);
    }

    public List<TimestampReference> getSignatureTimestampedReferences() {
        ArrayList<TimestampReference> references = new ArrayList<TimestampReference>();
        references.add(new TimestampReference(this.getId()));
        List signingCertificateTimestampReferences = super.getSigningCertificateTimestampReferences();
        for (TimestampReference timestampReference : signingCertificateTimestampReferences) {
            this.usedCertificatesDigestAlgorithms.add(timestampReference.getDigestAlgorithm());
        }
        references.addAll(signingCertificateTimestampReferences);
        return references;
    }

    private TimestampReference createCertificateTimestampReference(CertificateRef ref) {
        this.usedCertificatesDigestAlgorithms.add(ref.getDigestAlgorithm());
        return new TimestampReference(ref.getDigestAlgorithm(), Utils.toBase64((byte[])ref.getDigestValue()), TimestampedObjectType.CERTIFICATE);
    }

    public List<AdvancedSignature> getCounterSignatures() {
        return Collections.emptyList();
    }

    public List<CertificateRef> getCertificateRefs() {
        ArrayList<CertificateRef> refs = new ArrayList<CertificateRef>();
        if (this.dssDictionary != null) {
            Set<CertificateToken> certList = this.dssDictionary.getCertList();
            for (CertificateToken certificateToken : certList) {
                CertificateRef ref = new CertificateRef();
                ref.setDigestAlgorithm(DigestAlgorithm.SHA1);
                ref.setDigestValue(certificateToken.getDigest(DigestAlgorithm.SHA1));
                refs.add(ref);
            }
        }
        return refs;
    }

    public List<CRLRef> getCRLRefs() {
        return Collections.emptyList();
    }

    public List<OCSPRef> getOCSPRefs() {
        return Collections.emptyList();
    }

    public byte[] getSignatureTimestampData(TimestampToken timestampToken, String canonicalizationMethod) {
        if (super.getSignatureTimestamps().contains(timestampToken)) {
            return super.getSignatureTimestampData(timestampToken, null);
        }
        for (PdfSignatureOrDocTimestampInfo signatureInfo : this.pdfSignatureInfo.getOuterSignatures()) {
            PdfDocTimestampInfo pdfTimestampInfo;
            if (!(signatureInfo instanceof PdfDocTimestampInfo) || !(pdfTimestampInfo = (PdfDocTimestampInfo)signatureInfo).getTimestampToken().equals((Object)timestampToken)) continue;
            byte[] signedDocumentBytes = pdfTimestampInfo.getSignedDocumentBytes();
            return signedDocumentBytes;
        }
        throw new DSSException("Timestamp Data not found");
    }

    public byte[] getTimestampX1Data(TimestampToken timestampToken, String canonicalizationMethod) {
        return null;
    }

    public byte[] getTimestampX2Data(TimestampToken timestampToken, String canonicalizationMethod) {
        return null;
    }

    public CAdESSignature getCAdESSignature() {
        return this.pdfSignatureInfo.getCades();
    }

    public byte[] getArchiveTimestampData(TimestampToken timestampToken, String canonicalizationMethod) {
        for (PdfSignatureOrDocTimestampInfo signatureInfo : this.pdfSignatureInfo.getOuterSignatures()) {
            PdfDocTimestampInfo pdfTimestampInfo;
            if (!(signatureInfo instanceof PdfDocTimestampInfo) || !(pdfTimestampInfo = (PdfDocTimestampInfo)signatureInfo).getTimestampToken().equals((Object)timestampToken)) continue;
            byte[] signedDocumentBytes = pdfTimestampInfo.getSignedDocumentBytes();
            return signedDocumentBytes;
        }
        throw new DSSException("Timestamp Data not found");
    }

    public String getId() {
        String cadesId = super.getId();
        return cadesId + this.getDigestOfByteRange();
    }

    private String getDigestOfByteRange() {
        int[] signatureByteRange = this.pdfSignatureInfo.getSignatureByteRange();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i : signatureByteRange) {
            baos.write(i);
        }
        return DSSUtils.getMD5Digest((byte[])baos.toByteArray());
    }

    public List<TimestampReference> getTimestampedReferences() {
        return Collections.emptyList();
    }

    public boolean isDataForSignatureLevelPresent(SignatureLevel signatureLevel) {
        boolean dataForLevelPresent = true;
        switch (signatureLevel) {
            case PDF_NOT_ETSI: {
                break;
            }
            case PAdES_BASELINE_LTA: {
                dataForLevelPresent = this.hasLTAProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.PAdES_BASELINE_LT);
                break;
            }
            case PKCS7_LTA: {
                dataForLevelPresent = this.hasLTAProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.PKCS7_LT);
                break;
            }
            case PAdES_BASELINE_LT: {
                dataForLevelPresent = this.hasLTProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.PAdES_BASELINE_T);
                break;
            }
            case PKCS7_LT: {
                dataForLevelPresent = this.hasLTProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.PKCS7_T);
                break;
            }
            case PAdES_BASELINE_T: {
                dataForLevelPresent = this.hasTProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.PAdES_BASELINE_B);
                break;
            }
            case PKCS7_T: {
                dataForLevelPresent = this.hasTProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.PKCS7_B);
                break;
            }
            case PAdES_BASELINE_B: {
                dataForLevelPresent = this.pdfSignatureInfo != null && "ETSI.CAdES.detached".equals(this.pdfSignatureInfo.getSubFilter());
                break;
            }
            case PKCS7_B: {
                dataForLevelPresent = this.pdfSignatureInfo != null && "adbe.pkcs7.detached".equals(this.pdfSignatureInfo.getSubFilter());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level " + signatureLevel);
            }
        }
        LOG.debug("Level {} found on document {} = {}", new Object[]{signatureLevel, this.document.getName(), dataForLevelPresent});
        return dataForLevelPresent;
    }

    public SignatureLevel[] getSignatureLevels() {
        return new SignatureLevel[]{SignatureLevel.PDF_NOT_ETSI, SignatureLevel.PAdES_BASELINE_B, SignatureLevel.PKCS7_B, SignatureLevel.PAdES_BASELINE_T, SignatureLevel.PKCS7_T, SignatureLevel.PAdES_BASELINE_LT, SignatureLevel.PKCS7_LT, SignatureLevel.PAdES_BASELINE_LTA, SignatureLevel.PKCS7_LTA};
    }

    public boolean hasOuterSignatures() {
        return Utils.isCollectionNotEmpty(this.pdfSignatureInfo.getOuterSignatures());
    }

    public PdfSignatureInfo getPdfSignatureInfo() {
        return this.pdfSignatureInfo;
    }
}

