/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfByteRangeSignatureScope;
import eu.europa.esig.dss.pdf.PdfSignatureInfo;
import eu.europa.esig.dss.validation.FullSignatureScope;
import eu.europa.esig.dss.validation.SignatureScope;
import eu.europa.esig.dss.validation.SignatureScopeFinder;
import java.util.ArrayList;
import java.util.List;

public class PAdESSignatureScopeFinder
implements SignatureScopeFinder<PAdESSignature> {
    public List<SignatureScope> findSignatureScope(PAdESSignature pAdESSignature) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        PdfSignatureInfo pdfSignature = pAdESSignature.getPdfSignatureInfo();
        int outerSignatureSize = pdfSignature.getOuterSignatures().size();
        if (pAdESSignature.hasOuterSignatures()) {
            result.add((SignatureScope)new PdfByteRangeSignatureScope("PDF previous version #" + outerSignatureSize, pdfSignature.getSignatureByteRange()));
        } else {
            result.add((SignatureScope)new FullSignatureScope("Full PDF"));
        }
        return result;
    }
}

