/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PAdESSignatureScopeFinder;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PdfObjFactory;
import eu.europa.esig.dss.pdf.PdfSignatureInfo;
import eu.europa.esig.dss.pdf.PdfSignatureValidationCallback;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignatureScopeFinder;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class PDFDocumentValidator
extends SignedDocumentValidator {
    final PDFSignatureService pdfSignatureService;

    private PDFDocumentValidator() {
        super(null);
        this.pdfSignatureService = null;
    }

    public PDFDocumentValidator(DSSDocument document) {
        super((SignatureScopeFinder)new PAdESSignatureScopeFinder());
        this.document = document;
        this.pdfSignatureService = PdfObjFactory.getInstance().newPAdESSignatureService();
    }

    public boolean isSupported(DSSDocument dssDocument) {
        int headerLength = 50;
        byte[] preamble = new byte[headerLength];
        DSSUtils.readToArray((DSSDocument)dssDocument, (int)headerLength, (byte[])preamble);
        String preambleString = new String(preamble);
        return preambleString.startsWith("%PDF-");
    }

    public List<AdvancedSignature> getSignatures() {
        final ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        this.pdfSignatureService.validateSignatures(this.validationCertPool, this.document, new PdfSignatureValidationCallback(){

            @Override
            public void validate(PdfSignatureInfo pdfSignatureInfo) {
                try {
                    if (pdfSignatureInfo.getCades() != null) {
                        PAdESSignature padesSignature = new PAdESSignature(PDFDocumentValidator.this.document, pdfSignatureInfo, PDFDocumentValidator.this.validationCertPool);
                        padesSignature.setSignatureFilename(PDFDocumentValidator.this.document.getName());
                        padesSignature.setProvidedSigningCertificateToken(PDFDocumentValidator.this.providedSigningCertificateToken);
                        signatures.add(padesSignature);
                    }
                }
                catch (Exception e) {
                    throw new DSSException((Throwable)e);
                }
            }
        });
        return signatures;
    }

    public List<DSSDocument> getOriginalDocuments(String signatureId) throws DSSException {
        if (Utils.isStringBlank((String)signatureId)) {
            throw new NullPointerException("signatureId");
        }
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        List<AdvancedSignature> signatures = this.getSignatures();
        for (AdvancedSignature signature : signatures) {
            PAdESSignature padesSignature = (PAdESSignature)signature;
            if (!padesSignature.getId().equals(signatureId)) continue;
            CAdESSignature cadesSignature = padesSignature.getCAdESSignature();
            for (DSSDocument document : cadesSignature.getDetachedContents()) {
                InputStream is = null;
                try {
                    is = document.openStream();
                    byte[] content = Utils.toByteArray((InputStream)is);
                    result.add((DSSDocument)new InMemoryDocument(content));
                }
                catch (IOException e) {
                    throw new DSSException("Unable to retrieve the original document for document '" + document.getName() + "'", (Throwable)e);
                }
                finally {
                    Utils.closeQuietly((Closeable)is);
                }
            }
        }
        return result;
    }
}

