/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfDssDict {
    private static final Logger LOG = LoggerFactory.getLogger(PdfDssDict.class);
    private static final String DSS_DICTIONARY_NAME = "DSS";
    private static final String CERT_ARRAY_NAME_DSS = "Certs";
    private static final String OCSP_ARRAY_NAME_DSS = "OCSPs";
    private static final String CRL_ARRAY_NAME_DSS = "CRLs";
    private static final String VRI_DICTIONARY_NAME = "VRI";
    private static final String CERT_ARRAY_NAME_VRI = "Cert";
    private static final String OCSP_ARRAY_NAME_VRI = "OCSP";
    private static final String CRL_ARRAY_NAME_VRI = "CRL";
    private Set<byte[]> crlList = new HashSet<byte[]>();
    private Set<BasicOCSPResp> ocspList = new HashSet<BasicOCSPResp>();
    private Set<CertificateToken> certList = new HashSet<CertificateToken>();

    public static PdfDssDict extract(PdfDict documentDict) {
        PdfDict dssCatalog;
        if (documentDict != null && (dssCatalog = documentDict.getAsDict(DSS_DICTIONARY_NAME)) != null) {
            return new PdfDssDict(dssCatalog);
        }
        LOG.debug("No DSS dictionary found");
        return null;
    }

    private PdfDssDict(PdfDict dssDictionary) {
        this.readVRI(dssDictionary);
        this.readCerts(dssDictionary);
        this.readCrls(dssDictionary);
        this.readOcsps(dssDictionary);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readVRI(PdfDict dssDictionary) {
        PdfDict vriDict = dssDictionary.getAsDict(VRI_DICTIONARY_NAME);
        if (vriDict != null) {
            LOG.debug("There is a VRI dictionary in DSS dictionary");
            try {
                Object[] names = vriDict.list();
                if (!Utils.isArrayNotEmpty((Object[])names)) return;
                for (Object name : names) {
                    this.extractCertsFromArray(vriDict.getAsDict((String)name), "VRI/" + (String)name, CERT_ARRAY_NAME_VRI);
                    this.extractOCSPsFromArray(vriDict.getAsDict((String)name), "VRI/" + (String)name, OCSP_ARRAY_NAME_VRI);
                    this.extractCRLsFromArray(vriDict.getAsDict((String)name), "VRI/" + (String)name, CRL_ARRAY_NAME_VRI);
                }
                return;
            }
            catch (Exception e) {
                LOG.debug("Unable to analyse VRI dictionary : " + e.getMessage());
                return;
            }
        } else {
            LOG.debug("No VRI dictionary found in DSS dictionary");
        }
    }

    private void readCerts(PdfDict dssDictionary) {
        this.extractCertsFromArray(dssDictionary, DSS_DICTIONARY_NAME, CERT_ARRAY_NAME_DSS);
    }

    private void readOcsps(PdfDict dssDictionary) {
        this.extractOCSPsFromArray(dssDictionary, DSS_DICTIONARY_NAME, OCSP_ARRAY_NAME_DSS);
    }

    private void readCrls(PdfDict dssDictionary) {
        this.extractCRLsFromArray(dssDictionary, DSS_DICTIONARY_NAME, CRL_ARRAY_NAME_DSS);
    }

    private void extractCRLsFromArray(PdfDict dict, String dictionaryName, String arrayName) {
        PdfArray crlArray = dict.getAsArray(arrayName);
        if (crlArray != null) {
            LOG.debug("There are {} CRLs in {} dictionary", (Object)crlArray.size(), (Object)dictionaryName);
            for (int ii = 0; ii < crlArray.size(); ++ii) {
                try {
                    this.crlList.add(crlArray.getBytes(ii));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Unable to read CRL " + ii + " from " + dictionaryName + " dictionary : " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            LOG.debug("No CRLs found in {} dictionary", (Object)dictionaryName);
        }
    }

    private void extractCertsFromArray(PdfDict dict, String dictionaryName, String arrayName) {
        PdfArray certsArray = dict.getAsArray(arrayName);
        if (certsArray != null) {
            LOG.debug("There are {} certificates in {} dictionary", (Object)certsArray.size(), (Object)dictionaryName);
            for (int ii = 0; ii < certsArray.size(); ++ii) {
                try {
                    byte[] stream = certsArray.getBytes(ii);
                    CertificateToken cert = DSSUtils.loadCertificate((byte[])stream);
                    this.certList.add(cert);
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Unable to read Cert " + ii + " from " + dictionaryName + " dictionary : " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            LOG.debug("No Certs found in {} dictionary", (Object)dictionaryName);
        }
    }

    private void extractOCSPsFromArray(PdfDict dict, String dictionaryName, String arrayName) {
        PdfArray ocspArray = dict.getAsArray(arrayName);
        if (ocspArray != null) {
            LOG.debug("There are {} OCSPs in {} dictionary", (Object)ocspArray.size(), (Object)dictionaryName);
            for (int ii = 0; ii < ocspArray.size(); ++ii) {
                try {
                    byte[] stream = ocspArray.getBytes(ii);
                    OCSPResp ocspResp = new OCSPResp(stream);
                    BasicOCSPResp responseObject = (BasicOCSPResp)ocspResp.getResponseObject();
                    this.ocspList.add(responseObject);
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Unable to read OCSP " + ii + " from " + dictionaryName + " dictionary : " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            LOG.debug("No OCSPs found in {} dictionary", (Object)dictionaryName);
        }
    }

    public Set<byte[]> getCrlList() {
        return Collections.unmodifiableSet(this.crlList);
    }

    public Set<BasicOCSPResp> getOcspList() {
        return Collections.unmodifiableSet(this.ocspList);
    }

    public Set<CertificateToken> getCertList() {
        return Collections.unmodifiableSet(this.certList);
    }
}

