/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PDFTimestampService;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PdfObjFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)PdfObjFactory.class.getName());
    private static PdfObjFactory INSTANCE;

    public static PdfObjFactory getInstance() {
        if (INSTANCE == null) {
            String factoryClassName = System.getProperty("dss.pdf_obj_factory");
            if (factoryClassName != null) {
                LOG.info("Using '" + factoryClassName + "' as the PDF Object Factory Implementation");
                try {
                    Class<?> factoryClass = Class.forName(factoryClassName);
                    INSTANCE = (PdfObjFactory)factoryClass.newInstance();
                }
                catch (Exception ex) {
                    LOG.error("dss.pdf_obj_factory is '" + factoryClassName + "' but factory cannot be instantiated (fallback will be used)");
                }
            }
            if (INSTANCE == null) {
                LOG.info("Fallback to '" + PdfBoxObjectFactory.class.getName() + "' as the PDF Object Factory Implementation");
                INSTANCE = new PdfBoxObjectFactory();
            }
        }
        return INSTANCE;
    }

    public abstract PDFSignatureService newPAdESSignatureService();

    public abstract PDFTimestampService newTimestampSignatureService();
}

