/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSignatureOrDocTimestampInfo;
import eu.europa.esig.dss.utils.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PdfBoxCMSInfo
implements PdfSignatureOrDocTimestampInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PdfBoxCMSInfo.class);
    private final PdfDssDict dssDictionary;
    private final PdfDict signaturedictionary;
    private final Date signingDate;
    private final String location;
    private final String contactInfo;
    private final String reason;
    private final String filter;
    private final String subFilter;
    private final int[] signatureByteRange;
    private final byte[] cms;
    private final byte[] signedBytes;
    private boolean verified;
    private String uniqueId;
    private Set<PdfSignatureOrDocTimestampInfo> outerSignatures = new HashSet<PdfSignatureOrDocTimestampInfo>();

    PdfBoxCMSInfo(PDSignature signature, PdfDict dict, PdfDssDict dssDictionary, byte[] cms, byte[] signedContent) {
        this.cms = cms;
        this.location = signature.getLocation();
        this.reason = signature.getReason();
        this.contactInfo = signature.getContactInfo();
        this.filter = signature.getFilter();
        this.subFilter = signature.getSubFilter();
        this.signingDate = signature.getSignDate() != null ? signature.getSignDate().getTime() : null;
        this.signatureByteRange = signature.getByteRange();
        this.signaturedictionary = dict;
        this.dssDictionary = dssDictionary;
        this.signedBytes = signedContent;
    }

    @Override
    public void checkIntegrity() {
        if (!this.verified) {
            this.checkIntegrityOnce();
            LOG.debug("Verify embedded CAdES Signature on signedBytes size {}.", (Object)this.signedBytes.length);
            this.verified = true;
        }
    }

    protected abstract void checkIntegrityOnce();

    @Override
    public byte[] getSignedDocumentBytes() {
        return this.signedBytes;
    }

    @Override
    public byte[] getOriginalBytes() {
        int length = this.signatureByteRange[1];
        byte[] result = new byte[length];
        System.arraycopy(this.signedBytes, 0, result, 0, length);
        return result;
    }

    @Override
    public PdfDssDict getDssDictionary() {
        return this.dssDictionary;
    }

    @Override
    public PdfDict getSignatureDictionary() {
        return this.signaturedictionary;
    }

    @Override
    public String uniqueId() {
        if (this.uniqueId == null) {
            byte[] digest = DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA1, (byte[])this.cms);
            this.uniqueId = Utils.toHex((byte[])digest);
        }
        return this.uniqueId;
    }

    @Override
    public void addOuterSignature(PdfSignatureOrDocTimestampInfo signatureInfo) {
        this.outerSignatures.add(signatureInfo);
    }

    @Override
    public Set<PdfSignatureOrDocTimestampInfo> getOuterSignatures() {
        return Collections.unmodifiableSet(this.outerSignatures);
    }

    @Override
    public int[] getSignatureByteRange() {
        return this.signatureByteRange;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public Date getSigningDate() {
        return this.signingDate;
    }

    @Override
    public String getContactInfo() {
        return this.contactInfo;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public String getSubFilter() {
        return this.subFilter;
    }

    public String toString() {
        return "PdfBoxCMSInfo [subFilter=" + this.subFilter + ", uniqueId=" + this.uniqueId() + ", signatureByteRange=" + Arrays.toString(this.signatureByteRange) + ", outerSignatures=" + this.outerSignatures + "]";
    }
}

