/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;

class PdfBoxDict
implements PdfDict {
    private COSDictionary wrapped;
    private PDDocument document;

    public PdfBoxDict(COSDictionary wrapped, PDDocument document) {
        this.wrapped = wrapped;
        this.document = document;
    }

    @Override
    public PdfDict getAsDict(String name) {
        COSDictionary dict = (COSDictionary)this.wrapped.getDictionaryObject(name);
        if (dict == null) {
            return null;
        }
        return new PdfBoxDict(dict, this.document);
    }

    @Override
    public PdfArray getAsArray(String name) {
        COSArray array = (COSArray)this.wrapped.getDictionaryObject(name);
        if (array == null) {
            return null;
        }
        return new PdfBoxArray(array, this.document);
    }

    @Override
    public boolean hasAName(String name) {
        COSBase dictionaryObject = this.wrapped.getDictionaryObject(name);
        return dictionaryObject != null;
    }

    @Override
    public boolean hasANameWithValue(String name, String value) {
        COSName pdfName = (COSName)this.wrapped.getDictionaryObject(name);
        if (pdfName == null) {
            return false;
        }
        return pdfName.getName().equals(value);
    }

    @Override
    public byte[] get(String name) throws IOException {
        COSBase val = this.wrapped.getDictionaryObject(name);
        if (val == null) {
            return null;
        }
        if (val instanceof COSString) {
            return ((COSString)val).getBytes();
        }
        if (val instanceof COSName) {
            return ((COSName)val).getName().getBytes();
        }
        throw new IOException(name + " was expected to be a COSString element but was " + val.getClass() + " : " + val);
    }

    @Override
    public String[] list() {
        Set cosNames = this.wrapped.keySet();
        ArrayList<String> result = new ArrayList<String>(cosNames.size());
        for (COSName cosName : cosNames) {
            String name = cosName.getName();
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

