/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PDFTimestampService;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxSignatureService;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.tsp.TSPSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.bouncycastle.tsp.TimeStampToken;

class PdfBoxDocTimeStampService
extends PdfBoxSignatureService
implements PDFSignatureService,
PDFTimestampService {
    public static final COSName SUB_FILTER_ETSI_RFC3161 = COSName.getPDFName((String)"ETSI.RFC3161");

    PdfBoxDocTimeStampService() {
    }

    @Override
    protected COSName getType() {
        return COSName.DOC_TIME_STAMP;
    }

    @Override
    protected COSName getFilter(PAdESSignatureParameters parameters) {
        if (Utils.isStringNotEmpty((String)parameters.getTimestampFilter())) {
            return COSName.getPDFName((String)parameters.getTimestampFilter());
        }
        return PDSignature.FILTER_ADOBE_PPKLITE;
    }

    @Override
    protected COSName getSubFilter(PAdESSignatureParameters parameters) {
        if (Utils.isStringNotEmpty((String)parameters.getTimestampSubFilter())) {
            return COSName.getPDFName((String)parameters.getTimestampSubFilter());
        }
        return SUB_FILTER_ETSI_RFC3161;
    }

    @Override
    public void timestamp(DSSDocument document, OutputStream signedStream, PAdESSignatureParameters parameters, TSPSource tspSource) throws DSSException {
        DigestAlgorithm timestampDigestAlgorithm = parameters.getSignatureTimestampParameters().getDigestAlgorithm();
        InputStream inputStream = document.openStream();
        byte[] digest = this.digest(inputStream, parameters, timestampDigestAlgorithm);
        Utils.closeQuietly((Closeable)inputStream);
        TimeStampToken timeStampToken = tspSource.getTimeStampResponse(timestampDigestAlgorithm, digest);
        byte[] encoded = DSSASN1Utils.getEncoded((TimeStampToken)timeStampToken);
        inputStream = document.openStream();
        this.sign(inputStream, encoded, signedStream, parameters, timestampDigestAlgorithm);
        Utils.closeQuietly((Closeable)inputStream);
    }

    @Override
    protected void fillImageParameters(PDDocument doc, PAdESSignatureParameters signatureParameters, SignatureOptions options) throws IOException {
        SignatureImageParameters signatureImageParameters = signatureParameters.getTimestampImageParameters();
        this.fillImageParameters(doc, signatureImageParameters, options);
    }
}

