/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfDocTimestampInfo;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxCMSInfo;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.TimestampType;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfBoxDocTimestampInfo
extends PdfBoxCMSInfo
implements PdfDocTimestampInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PdfBoxDocTimestampInfo.class);
    private final TimestampToken timestampToken;
    private final byte[] content;

    PdfBoxDocTimestampInfo(CertificatePool validationCertPool, PDSignature signature, PdfDict dictionary, PdfDssDict dssDictionary, byte[] cms, byte[] signedContent, boolean isArchiveTimestamp) throws DSSException {
        super(signature, dictionary, dssDictionary, cms, signedContent);
        try {
            TimestampType timestampType = TimestampType.SIGNATURE_TIMESTAMP;
            if (isArchiveTimestamp) {
                timestampType = TimestampType.ARCHIVE_TIMESTAMP;
            }
            this.timestampToken = new TimestampToken(cms, timestampType, validationCertPool);
            this.content = cms;
            LOG.debug("Created PdfBoxDocTimestampInfo {} : {}", (Object)timestampType, (Object)this.uniqueId());
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    @Override
    public void checkIntegrityOnce() {
        SignatureCryptographicVerification signatureCryptographicVerification = new SignatureCryptographicVerification();
        signatureCryptographicVerification.setReferenceDataFound(false);
        signatureCryptographicVerification.setReferenceDataIntact(false);
        signatureCryptographicVerification.setSignatureIntact(false);
        if (this.getSignedDocumentBytes() != null) {
            signatureCryptographicVerification.setReferenceDataFound(true);
        }
        signatureCryptographicVerification.setReferenceDataIntact(this.timestampToken.matchData(this.getSignedDocumentBytes()));
        signatureCryptographicVerification.setSignatureIntact(this.timestampToken.isSignatureValid());
    }

    @Override
    public boolean isTimestamp() {
        return true;
    }

    @Override
    public TimestampToken getTimestampToken() {
        return this.timestampToken;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }
}

