/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSignatureInfo;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxCMSInfo;
import eu.europa.esig.dss.x509.CertificatePool;
import java.io.IOException;
import java.util.Arrays;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.cms.CMSException;

class PdfBoxSignatureInfo
extends PdfBoxCMSInfo
implements PdfSignatureInfo {
    private final CAdESSignature cades;
    private final byte[] content;

    PdfBoxSignatureInfo(CertificatePool validationCertPool, PDSignature signature, PdfDict dictionary, PdfDssDict dssDictionary, byte[] cms, byte[] originalBytes) throws IOException {
        super(signature, dictionary, dssDictionary, cms, originalBytes);
        try {
            this.cades = new CAdESSignature(cms, validationCertPool);
            this.content = cms;
            InMemoryDocument detachedContent = new InMemoryDocument(this.getSignedDocumentBytes());
            this.cades.setDetachedContents(Arrays.asList(detachedContent));
        }
        catch (CMSException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void checkIntegrityOnce() {
        this.cades.checkSignatureIntegrity();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PdfBoxSignatureInfo)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PdfBoxSignatureInfo that = (PdfBoxSignatureInfo)o;
        return this.cades.equals(that.cades);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.cades.hashCode();
        return result;
    }

    @Override
    public boolean isTimestamp() {
        return false;
    }

    @Override
    public CAdESSignature getCades() {
        return this.cades;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }
}

