/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.signature.visible.ImageAndResolution;
import eu.europa.esig.dss.pades.signature.visible.ImageUtils;
import eu.europa.esig.dss.pdf.DSSDictionaryCallback;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSignatureInfo;
import eu.europa.esig.dss.pdf.PdfSignatureOrDocTimestampInfo;
import eu.europa.esig.dss.pdf.PdfSignatureOrDocTimestampInfoComparator;
import eu.europa.esig.dss.pdf.SignatureValidationCallback;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxCMSInfo;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxDict;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxDocTimeStampService;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxDocTimestampInfo;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxSignatureInfo;
import eu.europa.esig.dss.pdf.pdfbox.SignatureImageAndPosition;
import eu.europa.esig.dss.pdf.pdfbox.SignatureImageAndPositionProcessor;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.Token;
import eu.europa.esig.dss.x509.crl.CRLToken;
import eu.europa.esig.dss.x509.ocsp.OCSPToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfBoxSignatureService
implements PDFSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(PdfBoxSignatureService.class);

    PdfBoxSignatureService() {
    }

    @Override
    public byte[] digest(InputStream toSignDocument, PAdESSignatureParameters parameters, DigestAlgorithm digestAlgorithm) throws DSSException {
        byte[] signatureValue = DSSUtils.EMPTY_BYTE_ARRAY;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PDDocument pdDocument = null;
        try {
            pdDocument = PDDocument.load((InputStream)toSignDocument);
            PDSignature pdSignature = this.createSignatureDictionary(parameters, pdDocument);
            byte[] byArray = this.signDocumentAndReturnDigest(parameters, signatureValue, outputStream, pdDocument, pdSignature, digestAlgorithm);
            return byArray;
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
        finally {
            Utils.closeQuietly((Closeable)pdDocument);
            Utils.closeQuietly((Closeable)outputStream);
        }
    }

    @Override
    public void sign(InputStream pdfData, byte[] signatureValue, OutputStream signedStream, PAdESSignatureParameters parameters, DigestAlgorithm digestAlgorithm) throws DSSException {
        PDDocument pdDocument = null;
        try {
            pdDocument = PDDocument.load((InputStream)pdfData);
            PDSignature pdSignature = this.createSignatureDictionary(parameters, pdDocument);
            this.signDocumentAndReturnDigest(parameters, signatureValue, signedStream, pdDocument, pdSignature, digestAlgorithm);
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
        finally {
            Utils.closeQuietly((Closeable)pdDocument);
        }
    }

    private byte[] signDocumentAndReturnDigest(PAdESSignatureParameters parameters, final byte[] signatureBytes, OutputStream fileOutputStream, PDDocument pdDocument, PDSignature pdSignature, DigestAlgorithm digestAlgorithm) throws DSSException {
        SignatureOptions options = new SignatureOptions();
        try {
            final MessageDigest digest = DSSUtils.getMessageDigest((DigestAlgorithm)digestAlgorithm);
            SignatureInterface signatureInterface = new SignatureInterface(){

                public byte[] sign(InputStream content) throws IOException {
                    int count;
                    byte[] b = new byte[4096];
                    while ((count = content.read(b)) > 0) {
                        digest.update(b, 0, count);
                    }
                    return signatureBytes;
                }
            };
            options.setPreferredSignatureSize(parameters.getSignatureSize());
            this.fillImageParameters(pdDocument, parameters, options);
            pdDocument.addSignature(pdSignature, signatureInterface, options);
            this.saveDocumentIncrementally(parameters, fileOutputStream, pdDocument);
            byte[] digestValue = digest.digest();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Digest to be signed: " + Utils.toHex((byte[])digestValue));
            }
            byte[] byArray = digestValue;
            return byArray;
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
        finally {
            Utils.closeQuietly((Closeable)options.getVisualSignature());
        }
    }

    protected void fillImageParameters(PDDocument doc, PAdESSignatureParameters signatureParameters, SignatureOptions options) throws IOException {
        SignatureImageParameters signatureImageParameters = signatureParameters.getSignatureImageParameters();
        this.fillImageParameters(doc, signatureImageParameters, options);
    }

    protected void fillImageParameters(PDDocument doc, SignatureImageParameters signatureImageParameters, SignatureOptions options) throws IOException {
        if (signatureImageParameters != null) {
            ImageAndResolution ires = ImageUtils.create(signatureImageParameters);
            SignatureImageAndPosition signatureImageAndPosition = SignatureImageAndPositionProcessor.process(signatureImageParameters, doc, ires);
            PDVisibleSignDesigner visibleSig = new PDVisibleSignDesigner(doc, (InputStream)new ByteArrayInputStream(signatureImageAndPosition.getSignatureImage()), signatureImageParameters.getPage());
            visibleSig.xAxis(signatureImageAndPosition.getX());
            visibleSig.yAxis(signatureImageAndPosition.getY());
            if (signatureImageParameters.getWidth() != 0 && signatureImageParameters.getHeight() != 0) {
                visibleSig.width((float)signatureImageParameters.getWidth());
                visibleSig.height((float)signatureImageParameters.getHeight());
            } else {
                visibleSig.width(ires.toXPoint(visibleSig.getWidth()));
                visibleSig.height(ires.toYPoint(visibleSig.getHeight()));
            }
            visibleSig.zoom((float)(signatureImageParameters.getZoom() - 100));
            PDVisibleSigProperties signatureProperties = new PDVisibleSigProperties();
            signatureProperties.visualSignEnabled(true).setPdVisibleSignature(visibleSig).buildSignature();
            options.setVisualSignature(signatureProperties);
            options.setPage(signatureImageParameters.getPage() - 1);
        }
    }

    private PDSignature createSignatureDictionary(PAdESSignatureParameters parameters, PDDocument pdDocument) {
        PDSignature signature = parameters.getSignatureFieldId() != null && !parameters.getSignatureFieldId().isEmpty() ? this.findExistingSignature(pdDocument, parameters.getSignatureFieldId()) : new PDSignature();
        signature.setType(this.getType());
        Date date = parameters.bLevel().getSigningDate();
        String encodedDate = " " + Utils.toHex((byte[])DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA1, (byte[])Long.toString(date.getTime()).getBytes()));
        CertificateToken token = parameters.getSigningCertificate();
        if (token == null) {
            signature.setName("Unknown signer" + encodedDate);
        } else {
            String shortName = DSSASN1Utils.getHumanReadableName((CertificateToken)parameters.getSigningCertificate()) + encodedDate;
            signature.setName(shortName);
        }
        signature.setFilter(this.getFilter(parameters));
        signature.setSubFilter(this.getSubFilter(parameters));
        if (COSName.SIG.equals((Object)this.getType())) {
            if (Utils.isStringNotEmpty((String)parameters.getContactInfo())) {
                signature.setContactInfo(parameters.getContactInfo());
            }
            if (Utils.isStringNotEmpty((String)parameters.getLocation())) {
                signature.setLocation(parameters.getLocation());
            }
            if (Utils.isStringNotEmpty((String)parameters.getReason())) {
                signature.setReason(parameters.getReason());
            }
        }
        Calendar cal = Calendar.getInstance();
        Date signingDate = parameters.bLevel().getSigningDate();
        cal.setTime(signingDate);
        signature.setSignDate(cal);
        return signature;
    }

    private PDSignature findExistingSignature(PDDocument doc, String sigFieldName) {
        PDSignatureField signatureField;
        PDAcroForm acroForm = doc.getDocumentCatalog().getAcroForm();
        if (acroForm != null && (signatureField = (PDSignatureField)acroForm.getField(sigFieldName)) != null) {
            PDSignature signature = signatureField.getSignature();
            if (signature == null) {
                signature = new PDSignature();
                signatureField.getCOSObject().setItem(COSName.V, (COSObjectable)signature);
                return signature;
            }
            throw new DSSException("The signature field '" + sigFieldName + "' can not be signed since its already signed.");
        }
        throw new DSSException("The signature field '" + sigFieldName + "' does not exist.");
    }

    public void saveDocumentIncrementally(PAdESSignatureParameters parameters, OutputStream outputStream, PDDocument pdDocument) throws DSSException {
        try {
            if (pdDocument.getDocumentId() == null) {
                byte[] documentIdBytes = DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA256, (byte[])parameters.bLevel().getSigningDate().toString().getBytes());
                pdDocument.setDocumentId(Long.valueOf(DSSUtils.toLong((byte[])documentIdBytes)));
            }
            pdDocument.saveIncremental(outputStream);
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    protected COSName getType() {
        return COSName.SIG;
    }

    protected COSName getFilter(PAdESSignatureParameters parameters) {
        if (Utils.isStringNotEmpty((String)parameters.getSignatureFilter())) {
            return COSName.getPDFName((String)parameters.getSignatureFilter());
        }
        return PDSignature.FILTER_ADOBE_PPKLITE;
    }

    protected COSName getSubFilter(PAdESSignatureParameters parameters) {
        if (Utils.isStringNotEmpty((String)parameters.getSignatureSubFilter())) {
            return COSName.getPDFName((String)parameters.getSignatureSubFilter());
        }
        return PDSignature.SUBFILTER_ETSI_CADES_DETACHED;
    }

    @Override
    public void validateSignatures(CertificatePool validationCertPool, DSSDocument document, SignatureValidationCallback callback) throws DSSException {
        InputStream inputStream = document.openStream();
        try {
            List<PdfSignatureOrDocTimestampInfo> signaturesFound = this.getSignatures(validationCertPool, Utils.toByteArray((InputStream)inputStream));
            for (PdfSignatureOrDocTimestampInfo pdfSignatureOrDocTimestampInfo : signaturesFound) {
                callback.validate(pdfSignatureOrDocTimestampInfo);
            }
        }
        catch (IOException e) {
            LOG.error("Cannot validate signatures : " + e.getMessage(), (Throwable)e);
        }
        Utils.closeQuietly((Closeable)inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PdfSignatureOrDocTimestampInfo> getSignatures(CertificatePool validationCertPool, byte[] originalBytes) {
        ArrayList<PdfSignatureOrDocTimestampInfo> signatures = new ArrayList<PdfSignatureOrDocTimestampInfo>();
        PDDocument doc = null;
        try {
            doc = PDDocument.load((byte[])originalBytes);
            List pdSignatures = doc.getSignatureDictionaries();
            if (Utils.isCollectionNotEmpty((Collection)pdSignatures)) {
                LOG.debug("{} signature(s) found", (Object)pdSignatures.size());
                PdfBoxDict catalog = new PdfBoxDict(doc.getDocumentCatalog().getCOSObject(), doc);
                PdfDssDict dssDictionary = PdfDssDict.extract(catalog);
                for (PDSignature signature : pdSignatures) {
                    String subFilter = signature.getSubFilter();
                    int[] byteRange = signature.getByteRange();
                    this.validateByteRange(byteRange);
                    COSDictionary dict = signature.getCOSObject();
                    COSString item = (COSString)dict.getDictionaryObject(COSName.CONTENTS);
                    byte[] cms = item.getBytes();
                    byte[] cmsWithByteRange = signature.getContents(originalBytes);
                    if (!Arrays.equals(cmsWithByteRange, cms)) {
                        LOG.warn("The byte range doesn't match found /Content value!");
                    }
                    if (Utils.isStringEmpty((String)subFilter) || Utils.isArrayEmpty((byte[])cms)) {
                        LOG.warn("Wrong signature with empty subfilter or cms.");
                        continue;
                    }
                    byte[] signedContent = signature.getSignedContent(originalBytes);
                    PdfBoxDict signatureDictionary = new PdfBoxDict(signature.getCOSObject(), doc);
                    PdfBoxCMSInfo signatureInfo = null;
                    if (PdfBoxDocTimeStampService.SUB_FILTER_ETSI_RFC3161.getName().equals(subFilter)) {
                        boolean isArchiveTimestamp = false;
                        if (dssDictionary != null && this.isDSSDictionaryPresentInPreviousRevision(this.getOriginalBytes(byteRange, signedContent))) {
                            isArchiveTimestamp = true;
                        }
                        signatureInfo = new PdfBoxDocTimestampInfo(validationCertPool, signature, signatureDictionary, dssDictionary, cms, signedContent, isArchiveTimestamp);
                    } else {
                        signatureInfo = new PdfBoxSignatureInfo(validationCertPool, signature, signatureDictionary, dssDictionary, cms, signedContent);
                    }
                    if (signatureInfo == null) continue;
                    signatures.add(signatureInfo);
                }
                Collections.sort(signatures, new PdfSignatureOrDocTimestampInfoComparator());
                this.linkSignatures(signatures);
                for (PdfSignatureOrDocTimestampInfo sig : signatures) {
                    LOG.debug("Signature " + sig.uniqueId() + " found with byteRange " + Arrays.toString(sig.getSignatureByteRange()) + " (" + sig.getSubFilter() + ")");
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot analyze signatures : " + e.getMessage(), (Throwable)e);
        }
        finally {
            Utils.closeQuietly((Closeable)doc);
        }
        return signatures;
    }

    private void validateByteRange(int[] byteRange) {
        if (byteRange == null || byteRange.length != 4) {
            throw new DSSException("Incorrect BytRange size");
        }
        int a = byteRange[0];
        int b = byteRange[1];
        int c = byteRange[2];
        int d = byteRange[3];
        if (a != 0) {
            throw new DSSException("The BytRange must cover start of file");
        }
        if (b <= 0) {
            throw new DSSException("The first hash part doesn't cover anything");
        }
        if (c <= b) {
            throw new DSSException("The second hash part must start after the first hash part");
        }
        if (d <= 0) {
            throw new DSSException("The second hash part doesn't cover anything");
        }
    }

    private void linkSignatures(List<PdfSignatureOrDocTimestampInfo> signatures) {
        ArrayList<PdfSignatureOrDocTimestampInfo> previousList = new ArrayList<PdfSignatureOrDocTimestampInfo>();
        for (PdfSignatureOrDocTimestampInfo sig : signatures) {
            if (Utils.isCollectionNotEmpty(previousList)) {
                for (PdfSignatureOrDocTimestampInfo previous : previousList) {
                    previous.addOuterSignature(sig);
                }
            }
            previousList.add(sig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDSSDictionaryPresentInPreviousRevision(byte[] originalBytes) {
        PDDocument doc = null;
        PdfDssDict dssDictionary = null;
        try {
            doc = PDDocument.load((byte[])originalBytes);
            List pdSignatures = doc.getSignatureDictionaries();
            if (Utils.isCollectionNotEmpty((Collection)pdSignatures)) {
                PdfBoxDict catalog = new PdfBoxDict(doc.getDocumentCatalog().getCOSObject(), doc);
                dssDictionary = PdfDssDict.extract(catalog);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot check in previous revisions if DSS dictionary already exist : " + e.getMessage(), (Throwable)e);
        }
        finally {
            Utils.closeQuietly((Closeable)doc);
        }
        return dssDictionary != null;
    }

    private byte[] getOriginalBytes(int[] byteRange, byte[] signedContent) {
        int length = byteRange[1];
        byte[] result = new byte[length];
        System.arraycopy(signedContent, 0, result, 0, length);
        return result;
    }

    @Override
    public void addDssDictionary(InputStream inputStream, OutputStream outputStream, List<DSSDictionaryCallback> callbacks) {
        PDDocument pdDocument = null;
        try {
            pdDocument = PDDocument.load((InputStream)inputStream);
            if (Utils.isCollectionNotEmpty(callbacks)) {
                COSDictionary cosDictionary = pdDocument.getDocumentCatalog().getCOSObject();
                cosDictionary.setItem("DSS", (COSBase)this.buildDSSDictionary(callbacks));
                cosDictionary.setNeedToBeUpdated(true);
            }
            pdDocument.saveIncremental(outputStream);
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
        finally {
            Utils.closeQuietly((Closeable)pdDocument);
        }
    }

    private COSDictionary buildDSSDictionary(List<DSSDictionaryCallback> callbacks) throws Exception {
        COSDictionary dss = new COSDictionary();
        HashMap<String, COSStream> streams = new HashMap<String, COSStream>();
        HashSet<CRLToken> allCrls = new HashSet<CRLToken>();
        HashSet<OCSPToken> allOcsps = new HashSet<OCSPToken>();
        HashSet<CertificateToken> allCertificates = new HashSet<CertificateToken>();
        COSDictionary vriDictionary = new COSDictionary();
        for (DSSDictionaryCallback callback : callbacks) {
            COSDictionary sigVriDictionary = new COSDictionary();
            sigVriDictionary.setDirect(true);
            if (Utils.isCollectionNotEmpty(callback.getCertificates())) {
                COSArray vriCertArray = new COSArray();
                for (CertificateToken certificateToken : callback.getCertificates()) {
                    vriCertArray.add((COSBase)this.getStream(streams, (Token)certificateToken));
                    allCertificates.add(certificateToken);
                }
                sigVriDictionary.setItem("Cert", (COSBase)vriCertArray);
            }
            if (Utils.isCollectionNotEmpty(callback.getOcsps())) {
                COSArray vriOcspArray = new COSArray();
                for (OCSPToken oCSPToken : callback.getOcsps()) {
                    vriOcspArray.add((COSBase)this.getStream(streams, (Token)oCSPToken));
                    allOcsps.add(oCSPToken);
                }
                sigVriDictionary.setItem("OCSP", (COSBase)vriOcspArray);
            }
            if (Utils.isCollectionNotEmpty(callback.getCrls())) {
                COSArray vriCrlArray = new COSArray();
                for (CRLToken cRLToken : callback.getCrls()) {
                    vriCrlArray.add((COSBase)this.getStream(streams, (Token)cRLToken));
                    allCrls.add(cRLToken);
                }
                sigVriDictionary.setItem("CRL", (COSBase)vriCrlArray);
            }
            PdfSignatureInfo pdfSignatureInfo = callback.getSignature().getPdfSignatureInfo();
            byte[] digest = DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA1, (byte[])pdfSignatureInfo.getContent());
            String string = Utils.toHex((byte[])digest).toUpperCase();
            vriDictionary.setItem(string, (COSBase)sigVriDictionary);
        }
        dss.setItem("VRI", (COSBase)vriDictionary);
        if (Utils.isCollectionNotEmpty(allCertificates)) {
            COSArray arrayAllCerts = new COSArray();
            for (CertificateToken token : allCertificates) {
                arrayAllCerts.add((COSBase)this.getStream(streams, (Token)token));
            }
            dss.setItem("Certs", (COSBase)arrayAllCerts);
        }
        if (Utils.isCollectionNotEmpty(allOcsps)) {
            COSArray arrayAllOcsps = new COSArray();
            for (CertificateToken token : allOcsps) {
                arrayAllOcsps.add((COSBase)this.getStream(streams, (Token)token));
            }
            dss.setItem("OCSPs", (COSBase)arrayAllOcsps);
        }
        if (Utils.isCollectionNotEmpty(allCrls)) {
            COSArray arrayAllCrls = new COSArray();
            for (CertificateToken token : allCrls) {
                arrayAllCrls.add((COSBase)this.getStream(streams, (Token)token));
            }
            dss.setItem("CRLs", (COSBase)arrayAllCrls);
        }
        return dss;
    }

    private COSStream getStream(Map<String, COSStream> streams, Token token) throws IOException {
        COSStream stream = streams.get(token.getDSSIdAsString());
        if (stream == null) {
            stream = new COSStream();
            try (OutputStream unfilteredStream = stream.createOutputStream();){
                unfilteredStream.write(token.getEncoded());
                unfilteredStream.flush();
            }
            streams.put(token.getDSSIdAsString(), stream);
        }
        return stream;
    }

    @Override
    public List<String> getAvailableSignatureFields(DSSDocument document) throws DSSException {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream is = document.openStream();){
            PDDocument pdfDoc = PDDocument.load((InputStream)is);
            List signatureFields = pdfDoc.getSignatureFields();
            for (PDSignatureField pdSignatureField : signatureFields) {
                PDSignature signature = pdSignatureField.getSignature();
                if (signature != null) continue;
                result.add(pdSignatureField.getPartialName());
            }
        }
        catch (Exception e) {
            throw new DSSException("Unable to determine signature fields", (Throwable)e);
        }
        return result;
    }

    @Override
    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters) {
        InMemoryDocument newPdfDoc = null;
        try (InputStream is = document.openStream();){
            PDDocument pdfDoc = PDDocument.load((InputStream)is);
            PDPage page = pdfDoc.getPage(parameters.getPage());
            PDAcroForm acroForm = pdfDoc.getDocumentCatalog().getAcroForm();
            if (acroForm == null) {
                acroForm = new PDAcroForm(pdfDoc);
                pdfDoc.getDocumentCatalog().setAcroForm(acroForm);
                PDResources resources = new PDResources();
                resources.put(COSName.getPDFName((String)"Helv"), (PDFont)PDType1Font.HELVETICA);
                acroForm.setDefaultResources(resources);
                acroForm.setDefaultAppearance("/Helv 0 Tf 0 g");
            }
            PDSignatureField signatureField = new PDSignatureField(acroForm);
            if (Utils.isStringNotBlank((String)parameters.getName())) {
                signatureField.setPartialName(parameters.getName());
            }
            PDAnnotationWidget widget = (PDAnnotationWidget)signatureField.getWidgets().get(0);
            PDRectangle rect = new PDRectangle(parameters.getOriginX(), parameters.getOriginY(), parameters.getWidth(), parameters.getHeight());
            widget.setRectangle(rect);
            widget.setPage(page);
            page.getAnnotations().add(widget);
            acroForm.getFields().add(signatureField);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            pdfDoc.save((OutputStream)baos);
            pdfDoc.close();
            newPdfDoc = new InMemoryDocument(baos.toByteArray(), "new-document.pdf", MimeType.PDF);
        }
        catch (Exception e) {
            throw new DSSException("Unable to add a new signature fields", (Throwable)e);
        }
        return newPdfDoc;
    }
}

