/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESTimestampParameters;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.pades.CertificationPermission;
import eu.europa.esig.dss.pades.PAdESCommonParameters;
import eu.europa.esig.dss.pades.PAdESTimestampParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESSignatureParameters
extends CAdESSignatureParameters
implements PAdESCommonParameters {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESSignatureParameters.class);
    private static final long serialVersionUID = -1632557456487796227L;
    private String reason;
    private String contactInfo;
    private String location;
    private String signatureFieldId;
    private int signatureSize = 9472;
    private String signatureFilter = "Adobe.PPKLite";
    private String signatureSubFilter = "ETSI.CAdES.detached";
    private String signerName;
    private SignatureImageParameters signatureImageParameters;
    private CertificationPermission permission;
    private String passwordProtection;

    public void setSignatureLevel(SignatureLevel signatureLevel) {
        if (signatureLevel == null || SignatureForm.PAdES != signatureLevel.getSignatureForm()) {
            throw new IllegalArgumentException("Only PAdES form is allowed !");
        }
        super.setSignatureLevel(signatureLevel);
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(String contactInfo) {
        this.contactInfo = contactInfo;
    }

    @Override
    public String getFilter() {
        return this.signatureFilter;
    }

    public void setFilter(String signatureFilter) {
        this.signatureFilter = signatureFilter;
    }

    @Override
    public String getSubFilter() {
        return this.signatureSubFilter;
    }

    public void setSubFilter(String signatureSubFilter) {
        this.signatureSubFilter = signatureSubFilter;
    }

    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    @Override
    public SignatureImageParameters getImageParameters() {
        return this.signatureImageParameters;
    }

    public void setImageParameters(SignatureImageParameters signatureImageParameters) {
        this.signatureImageParameters = signatureImageParameters;
    }

    public void setSignaturePackaging(SignaturePackaging signaturePackaging) {
        LOG.warn("Cannot set a SignaturePackaging for PAdES signature. Only ENVELOPED packaging is allowed!");
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public String getFieldId() {
        return this.signatureFieldId;
    }

    public void setSignatureFieldId(String signatureFieldId) {
        this.signatureFieldId = signatureFieldId;
    }

    @Override
    public int getContentSize() {
        return this.signatureSize;
    }

    public void setContentSize(int signatureSize) {
        this.signatureSize = signatureSize;
    }

    public CertificationPermission getPermission() {
        return this.permission;
    }

    public void setPermission(CertificationPermission permission) {
        this.permission = permission;
    }

    @Override
    public String getPasswordProtection() {
        return this.passwordProtection;
    }

    public void setPasswordProtection(String passwordProtection) {
        this.passwordProtection = passwordProtection;
    }

    @Override
    public Date getSigningDate() {
        return this.bLevel().getSigningDate();
    }

    public PAdESTimestampParameters getContentTimestampParameters() {
        if (this.contentTimestampParameters == null) {
            this.contentTimestampParameters = new PAdESTimestampParameters();
        }
        return (PAdESTimestampParameters)this.contentTimestampParameters;
    }

    public void setContentTimestampParameters(CAdESTimestampParameters contentTimestampParameters) {
        this.contentTimestampParameters = contentTimestampParameters instanceof PAdESTimestampParameters ? contentTimestampParameters : new PAdESTimestampParameters(contentTimestampParameters);
    }

    public PAdESTimestampParameters getSignatureTimestampParameters() {
        if (this.signatureTimestampParameters == null) {
            this.signatureTimestampParameters = new PAdESTimestampParameters();
        }
        return (PAdESTimestampParameters)this.signatureTimestampParameters;
    }

    public void setSignatureTimestampParameters(CAdESTimestampParameters signatureTimestampParameters) {
        this.signatureTimestampParameters = signatureTimestampParameters instanceof PAdESTimestampParameters ? signatureTimestampParameters : new PAdESTimestampParameters(signatureTimestampParameters);
    }

    public PAdESTimestampParameters getArchiveTimestampParameters() {
        if (this.archiveTimestampParameters == null) {
            this.archiveTimestampParameters = new PAdESTimestampParameters();
        }
        return (PAdESTimestampParameters)this.archiveTimestampParameters;
    }

    public void setArchiveTimestampParameters(CAdESTimestampParameters archiveTimestampParameters) {
        this.archiveTimestampParameters = archiveTimestampParameters instanceof PAdESTimestampParameters ? archiveTimestampParameters : new PAdESTimestampParameters(archiveTimestampParameters);
    }
}

