/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.PAdESTimestampParameters;
import eu.europa.esig.dss.pades.timestamp.PAdESTimestampService;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;

class PAdESLevelBaselineT
implements SignatureExtension<PAdESSignatureParameters> {
    private final TSPSource tspSource;
    private final IPdfObjFactory pdfObjectFactory;

    protected PAdESLevelBaselineT(TSPSource tspSource, IPdfObjFactory pdfObjectFactory) {
        this.tspSource = tspSource;
        this.pdfObjectFactory = pdfObjectFactory;
    }

    public DSSDocument extendSignatures(DSSDocument document, PAdESSignatureParameters params) throws DSSException {
        return this.timestampDocument(document, params.getSignatureTimestampParameters(), params.getPasswordProtection());
    }

    protected DSSDocument timestampDocument(DSSDocument document, PAdESTimestampParameters timestampParameters, String pwd) {
        PAdESTimestampService padesTimestampService = new PAdESTimestampService(this.tspSource, this.newPdfSignatureService());
        timestampParameters.setPasswordProtection(pwd);
        return padesTimestampService.timestampDocument(document, timestampParameters);
    }

    protected PDFSignatureService newPdfSignatureService() {
        return this.pdfObjectFactory.newSignatureTimestampService();
    }
}

