/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.timestamp;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.pades.PAdESTimestampParameters;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;

public class PAdESTimestampService {
    private final TSPSource tspSource;
    private final PDFSignatureService pdfSignatureService;

    public PAdESTimestampService(TSPSource tspSource, PDFSignatureService pdfSignatureService) {
        this.tspSource = tspSource;
        this.pdfSignatureService = pdfSignatureService;
    }

    public DSSDocument timestampDocument(DSSDocument document, PAdESTimestampParameters params) throws DSSException {
        DigestAlgorithm timestampDigestAlgorithm = params.getDigestAlgorithm();
        byte[] digest = this.pdfSignatureService.digest(document, params);
        TimestampBinary timeStampToken = this.tspSource.getTimeStampResponse(timestampDigestAlgorithm, digest);
        byte[] encoded = DSSASN1Utils.getDEREncoded((TimestampBinary)timeStampToken);
        return this.pdfSignatureService.sign(document, encoded, params);
    }
}

