/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.RevocationInfoArchival;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x509.CertificateList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESCRLSource
extends OfflineCRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESCRLSource.class);
    private final PdfDssDict dssDictionary;
    private final String vriDictionaryName;
    private Map<Long, CRLBinary> crlMap;
    private final AttributeTable signedAttributes;

    public PAdESCRLSource(PdfDssDict dssDictionary) {
        this(dssDictionary, null, null);
    }

    public PAdESCRLSource(PdfDssDict dssDictionary, String vriDictionaryName, AttributeTable signedAttributes) {
        this.dssDictionary = dssDictionary;
        this.vriDictionaryName = vriDictionaryName;
        this.signedAttributes = signedAttributes;
        this.appendContainedCRLResponses();
    }

    private void appendContainedCRLResponses() {
        this.extractDSSCRLs();
        this.extractVRICRLs();
        if (this.signedAttributes != null) {
            this.collectCRLArchivalValues(this.signedAttributes);
        }
    }

    private void collectCRLArchivalValues(AttributeTable attributes) {
        ASN1Encodable attValue = DSSASN1Utils.getAsn1Encodable((AttributeTable)attributes, (ASN1ObjectIdentifier)OID.adbe_revocationInfoArchival);
        RevocationInfoArchival revValues = PAdESUtils.getRevocationInfoArchivals(attValue);
        if (revValues != null) {
            for (CertificateList revValue : revValues.getCrlVals()) {
                try {
                    this.addBinary((EncapsulatedRevocationTokenIdentifier)CRLUtils.buildCRLBinary((byte[])revValue.getEncoded()), RevocationOrigin.ADBE_REVOCATION_INFO_ARCHIVAL);
                }
                catch (IOException e) {
                    LOG.warn("Could not convert CertificateList to CRLBinary : {}", (Object)e.getMessage());
                }
            }
        }
    }

    public Map<Long, CRLBinary> getCrlMap() {
        if (this.crlMap != null) {
            return this.crlMap;
        }
        return Collections.emptyMap();
    }

    private Map<Long, CRLBinary> getDssCrlMap() {
        if (this.dssDictionary != null) {
            this.crlMap = this.dssDictionary.getCRLs();
            return this.crlMap;
        }
        return Collections.emptyMap();
    }

    private void extractDSSCRLs() {
        for (CRLBinary crl : this.getDssCrlMap().values()) {
            this.addBinary((EncapsulatedRevocationTokenIdentifier)crl, RevocationOrigin.DSS_DICTIONARY);
        }
    }

    private PdfVRIDict findVriDict() {
        PdfVRIDict vriDictionary = null;
        if (this.dssDictionary != null) {
            List<PdfVRIDict> vriDictList = this.dssDictionary.getVRIs();
            if (this.vriDictionaryName != null && Utils.isCollectionNotEmpty(vriDictList)) {
                for (PdfVRIDict vriDict : vriDictList) {
                    if (!this.vriDictionaryName.equals(vriDict.getName())) continue;
                    vriDictionary = vriDict;
                    break;
                }
            }
        }
        return vriDictionary;
    }

    private void extractVRICRLs() {
        PdfVRIDict vriDictionary = this.findVriDict();
        if (vriDictionary != null) {
            for (Map.Entry<Long, CRLBinary> crlEntry : vriDictionary.getCRLs().entrySet()) {
                if (!this.crlMap.containsKey(crlEntry.getKey())) {
                    this.crlMap.put(crlEntry.getKey(), crlEntry.getValue());
                }
                this.addBinary((EncapsulatedRevocationTokenIdentifier)crlEntry.getValue(), RevocationOrigin.VRI_DICTIONARY);
            }
        }
    }
}

