/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.RevocationInfoArchival;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESOCSPSource
extends OfflineOCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESOCSPSource.class);
    private final PdfDssDict dssDictionary;
    private final String vriDictionaryName;
    private final AttributeTable signedAttributes;
    private transient Map<Long, BasicOCSPResp> ocspMap;

    public PAdESOCSPSource(PdfDssDict dssDictionary) {
        this(dssDictionary, null, null);
    }

    public PAdESOCSPSource(PdfDssDict dssDictionary, String vriDictionaryName, AttributeTable signedAttributes) {
        this.dssDictionary = dssDictionary;
        this.vriDictionaryName = vriDictionaryName;
        this.signedAttributes = signedAttributes;
        this.appendContainedOCSPResponses();
    }

    public void appendContainedOCSPResponses() {
        this.extractDSSOCSPs();
        this.extractVRIOCSPs();
        if (this.signedAttributes != null) {
            this.collectOCSPArchivalValues(this.signedAttributes);
        }
    }

    private void collectOCSPArchivalValues(AttributeTable attributes) {
        RevocationInfoArchival revocationArchival;
        ASN1Encodable attValue = DSSASN1Utils.getAsn1Encodable((AttributeTable)attributes, (ASN1ObjectIdentifier)OID.adbe_revocationInfoArchival);
        if (attValue != null && (revocationArchival = PAdESUtils.getRevocationInfoArchivals(attValue)) != null) {
            for (OCSPResponse ocspResponse : revocationArchival.getOcspVals()) {
                OCSPResp ocspResp = new OCSPResp(ocspResponse);
                try {
                    BasicOCSPResp basicOCSPResponse = (BasicOCSPResp)ocspResp.getResponseObject();
                    this.addBinary((EncapsulatedRevocationTokenIdentifier)OCSPResponseBinary.build((BasicOCSPResp)basicOCSPResponse), RevocationOrigin.ADBE_REVOCATION_INFO_ARCHIVAL);
                }
                catch (OCSPException e) {
                    LOG.warn("Error while extracting OCSPResponse from Revocation Info Archivals (ADBE) : {}", (Object)e.getMessage());
                }
            }
        }
    }

    public Map<Long, BasicOCSPResp> getOcspMap() {
        if (this.ocspMap != null) {
            return this.ocspMap;
        }
        return Collections.emptyMap();
    }

    private Map<Long, BasicOCSPResp> getDssOcspMap() {
        if (this.dssDictionary != null) {
            this.ocspMap = this.dssDictionary.getOCSPs();
            return this.ocspMap;
        }
        return Collections.emptyMap();
    }

    private void extractDSSOCSPs() {
        for (BasicOCSPResp basicOCSPResp : this.getDssOcspMap().values()) {
            this.addBinary((EncapsulatedRevocationTokenIdentifier)OCSPResponseBinary.build((BasicOCSPResp)basicOCSPResp), RevocationOrigin.DSS_DICTIONARY);
        }
    }

    private PdfVRIDict findVriDict() {
        PdfVRIDict vriDictionary = null;
        if (this.dssDictionary != null) {
            List<PdfVRIDict> vriDictList = this.dssDictionary.getVRIs();
            if (this.vriDictionaryName != null && Utils.isCollectionNotEmpty(vriDictList)) {
                for (PdfVRIDict vriDict : vriDictList) {
                    if (!this.vriDictionaryName.equals(vriDict.getName())) continue;
                    vriDictionary = vriDict;
                    break;
                }
            }
        }
        return vriDictionary;
    }

    private void extractVRIOCSPs() {
        PdfVRIDict vriDictionary = this.findVriDict();
        if (vriDictionary != null) {
            for (Map.Entry<Long, BasicOCSPResp> ocspEntry : vriDictionary.getOCSPs().entrySet()) {
                if (!this.ocspMap.containsKey(ocspEntry.getKey())) {
                    this.ocspMap.put(ocspEntry.getKey(), ocspEntry.getValue());
                }
                this.addBinary((EncapsulatedRevocationTokenIdentifier)OCSPResponseBinary.build((BasicOCSPResp)ocspEntry.getValue()), RevocationOrigin.VRI_DICTIONARY);
            }
        }
    }
}

