/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.validation.ByteRange;
import eu.europa.esig.dss.validation.SignatureIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;

public final class PAdESSignatureIdentifier
extends SignatureIdentifier {
    private static final long serialVersionUID = -7672798196825794558L;

    public PAdESSignatureIdentifier(PAdESSignature padesSignature) {
        super(PAdESSignatureIdentifier.buildBinaries(padesSignature));
    }

    private static byte[] buildBinaries(PAdESSignature padesSignature) {
        CertificateToken certificateToken = padesSignature.getSigningCertificateToken();
        TokenIdentifier identifier = certificateToken == null ? null : certificateToken.getDSSId();
        return SignatureIdentifier.buildSignatureIdentifier((Date)padesSignature.getSigningTime(), (TokenIdentifier)identifier, (String[])new String[]{PAdESSignatureIdentifier.getDigestOfByteRange(padesSignature.getPdfRevision())});
    }

    private static String getDigestOfByteRange(PdfSignatureRevision pdfSignatureRevision) {
        String string;
        ByteRange signatureByteRange = pdfSignatureRevision.getByteRange();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(signatureByteRange.toString().getBytes());
            string = DSSUtils.getMD5Digest((byte[])baos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("Cannot read byteRange : %s", signatureByteRange));
            }
        }
        baos.close();
        return string;
    }
}

