/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CAdESTimestampSource;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.validation.PAdESCRLSource;
import eu.europa.esig.dss.pades.validation.PAdESOCSPSource;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PAdESTimestampDataBuilder;
import eu.europa.esig.dss.pdf.PdfDocDssRevision;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.pdf.PdfSignatureDictionaryComparator;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.PdfRevision;
import eu.europa.esig.dss.validation.timestamp.TimestampCertificateSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PAdESTimestampSource
extends CAdESTimestampSource {
    private final transient PdfSignatureRevision pdfSignatureRevision;
    private final transient List<PdfRevision> documentRevisions;

    public PAdESTimestampSource(PAdESSignature signature, List<PdfRevision> documentRevisions) {
        super((CAdESSignature)signature);
        Objects.requireNonNull(documentRevisions, "List of Document revisions must be provided!");
        this.pdfSignatureRevision = signature.getPdfRevision();
        this.documentRevisions = this.reverseList(documentRevisions);
    }

    public List<TimestampToken> getDocumentTimestamps() {
        if (this.getSignatureTimestamps() == null || this.getArchiveTimestamps() == null) {
            this.createAndValidate();
        }
        ArrayList<TimestampToken> documentTimestamps = new ArrayList<TimestampToken>();
        documentTimestamps.addAll(this.getSignatureTimestamps());
        documentTimestamps.addAll(this.getArchiveTimestamps());
        return documentTimestamps;
    }

    protected PAdESTimestampDataBuilder getTimestampDataBuilder() {
        PAdESTimestampDataBuilder padesTimestampDataBuilder = new PAdESTimestampDataBuilder(this.documentRevisions, this.signerInformation, this.detachedDocuments);
        padesTimestampDataBuilder.setSignatureTimestamps(this.getSignatureTimestamps());
        return padesTimestampDataBuilder;
    }

    protected void makeTimestampTokens() {
        super.makeTimestampTokens();
        List cadesSignatureTimestamps = this.getSignatureTimestamps();
        ArrayList<TimestampToken> timestampedTimestamps = new ArrayList<TimestampToken>(cadesSignatureTimestamps);
        PdfSignatureDictionaryComparator revisionComparator = new PdfSignatureDictionaryComparator();
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (PdfRevision pdfRevision : this.documentRevisions) {
            if (pdfRevision instanceof PdfDocTimestampRevision) {
                PdfDocTimestampRevision timestampRevision = (PdfDocTimestampRevision)pdfRevision;
                TimestampToken timestampToken = timestampRevision.getTimestampToken();
                if (TimestampType.SIGNATURE_TIMESTAMP.equals((Object)timestampToken.getTimeStampType())) {
                    timestampToken.getTimestampedReferences().addAll(this.getSignatureTimestampReferences());
                    cadesSignatureTimestamps.add(timestampToken);
                } else {
                    ArrayList individualTimestampReferences = new ArrayList();
                    timestampToken.setArchiveTimestampType(this.getArchiveTimestampType());
                    if (Utils.isCollectionEmpty((Collection)cadesSignatureTimestamps)) {
                        this.addReferences(individualTimestampReferences, this.getSignatureTimestampReferences());
                    }
                    this.addReferences(individualTimestampReferences, references);
                    this.addReferencesForPreviousTimestamps(individualTimestampReferences, timestampedTimestamps);
                    TimestampCertificateSource timestampCertificateSource = timestampToken.getCertificateSource();
                    this.certificateSource.add((CertificateSource)timestampCertificateSource);
                    this.addReferences(references, this.createReferencesForCertificates(timestampCertificateSource.getCertificates()));
                    this.addReferences(references, individualTimestampReferences);
                    if (revisionComparator.compare(this.pdfSignatureRevision.getPdfSigDictInfo(), timestampRevision.getPdfSigDictInfo()) > 0) continue;
                    this.addReferences(timestampToken.getTimestampedReferences(), individualTimestampReferences);
                    this.getArchiveTimestamps().add(timestampToken);
                }
                this.populateSources(timestampToken);
                timestampedTimestamps.add(timestampToken);
                continue;
            }
            if (!(pdfRevision instanceof PdfDocDssRevision)) continue;
            PdfDocDssRevision dssRevision = (PdfDocDssRevision)pdfRevision;
            this.addReferencesForCertificates(references, dssRevision);
            this.addReferencesFromRevocationData(references, dssRevision);
        }
    }

    private List<PdfRevision> reverseList(List<PdfRevision> pdfRevisions) {
        ArrayList<PdfRevision> listCopy = new ArrayList<PdfRevision>(pdfRevisions);
        Collections.reverse(listCopy);
        return listCopy;
    }

    public List<TimestampedReference> getSignatureTimestampReferences() {
        List signatureTimestampReferences = super.getSignatureTimestampReferences();
        this.addReferences(signatureTimestampReferences, this.createReferencesForCertificates(this.signatureCertificateSource.getSignedDataCertificates()));
        return signatureTimestampReferences;
    }

    private void addReferencesForCertificates(List<TimestampedReference> references, PdfDocDssRevision dssRevision) {
        CommonCertificateSource dssRevisionCertificateSource = new CommonCertificateSource();
        Collection<CertificateToken> dssDictionaryCertValues = dssRevision.getDssDictionary().getCERTs().values();
        this.addReferences(references, this.createReferencesForCertificates(dssDictionaryCertValues));
        for (CertificateToken certificateToken : dssDictionaryCertValues) {
            dssRevisionCertificateSource.addCertificate(certificateToken);
        }
        if (Utils.isCollectionNotEmpty(dssRevision.getDssDictionary().getVRIs())) {
            for (PdfVRIDict vriDict : dssRevision.getDssDictionary().getVRIs()) {
                Collection<CertificateToken> vriDictionaryCertValues = vriDict.getCERTs().values();
                this.addReferences(references, this.createReferencesForCertificates(vriDictionaryCertValues));
                for (CertificateToken certificateToken : vriDictionaryCertValues) {
                    dssRevisionCertificateSource.addCertificate(certificateToken);
                }
            }
        }
        this.certificateSource.add((CertificateSource)dssRevisionCertificateSource);
    }

    private void addReferencesFromRevocationData(List<TimestampedReference> references, PdfDocDssRevision dssRevision) {
        PAdESCRLSource padesCRLSource = new PAdESCRLSource(dssRevision.getDssDictionary());
        for (EncapsulatedRevocationTokenIdentifier token : padesCRLSource.getDSSDictionaryBinaries()) {
            this.addReference(references, (Identifier)token, TimestampedObjectType.REVOCATION);
        }
        for (EncapsulatedRevocationTokenIdentifier token : padesCRLSource.getVRIDictionaryBinaries()) {
            this.addReference(references, (Identifier)token, TimestampedObjectType.REVOCATION);
        }
        this.crlSource.add((OfflineRevocationSource)padesCRLSource);
        PAdESOCSPSource padesOCSPSource = new PAdESOCSPSource(dssRevision.getDssDictionary());
        for (EncapsulatedRevocationTokenIdentifier token : padesOCSPSource.getDSSDictionaryBinaries()) {
            this.addReference(references, (Identifier)token, TimestampedObjectType.REVOCATION);
        }
        for (EncapsulatedRevocationTokenIdentifier token : padesOCSPSource.getVRIDictionaryBinaries()) {
            this.addReference(references, (Identifier)token, TimestampedObjectType.REVOCATION);
        }
        this.ocspSource.add((OfflineRevocationSource)padesOCSPSource);
    }

    protected boolean isCompleteCertificateRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isAttributeCertificateRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isCompleteRevocationRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isAttributeRevocationRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isRefsOnlyTimestamp(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isSigAndRefsTimestamp(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isCertificateValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isRevocationValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isArchiveTimestamp(CAdESAttribute unsignedAttribute) {
        return false;
    }

    private ArchiveTimestampType getArchiveTimestampType() {
        return this.getArchiveTimestampType((CAdESAttribute)null);
    }

    protected ArchiveTimestampType getArchiveTimestampType(CAdESAttribute unsignedAttribute) {
        return ArchiveTimestampType.PAdES;
    }
}

