/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.enumerations.TimestampLocation;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.PAdESCRLSource;
import eu.europa.esig.dss.pades.validation.PAdESOCSPSource;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.scope.PAdESSignatureScopeFinder;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PdfDocDssRevision;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.pdf.ServiceLoaderPdfObjFactory;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.DiagnosticDataBuilder;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.PdfRevision;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PDFDocumentValidator
extends SignedDocumentValidator {
    private static final byte[] pdfPreamble = new byte[]{37, 80, 68, 70, 45};
    private IPdfObjFactory pdfObjectFactory = new ServiceLoaderPdfObjFactory();
    private List<PdfRevision> documentRevisions;
    private String passwordProtection;

    PDFDocumentValidator() {
    }

    public PDFDocumentValidator(DSSDocument document) {
        super((SignatureScopeFinder)new PAdESSignatureScopeFinder());
        this.document = document;
    }

    public boolean isSupported(DSSDocument dssDocument) {
        return DSSUtils.compareFirstBytes((DSSDocument)dssDocument, (byte[])pdfPreamble);
    }

    public void setPdfObjFactory(IPdfObjFactory pdfObjFactory) {
        Objects.requireNonNull(pdfObjFactory, "PdfObjFactory is null");
        this.pdfObjectFactory = pdfObjFactory;
    }

    public void setPasswordProtection(String pwd) {
        this.passwordProtection = pwd;
    }

    protected DiagnosticDataBuilder prepareDiagnosticDataBuilder(ValidationContext validationContext) {
        List allSignatures = this.getAllSignatures();
        List<TimestampToken> detachedTimestamps = this.getDetachedTimestamps();
        List<PdfDssDict> dssDictionaries = this.getDssDictionaries();
        ListRevocationSource<CRL> listCRLSource = this.mergeCRLSources(allSignatures, detachedTimestamps, dssDictionaries);
        ListRevocationSource<OCSP> listOCSPSource = this.mergeOCSPSources(allSignatures, detachedTimestamps, dssDictionaries);
        ListCertificateSource listCertificateSource = this.mergeCertificateSource(allSignatures, detachedTimestamps, dssDictionaries);
        this.prepareCertificateVerifier(listCRLSource, listOCSPSource, listCertificateSource);
        this.prepareSignatureValidationContext(validationContext, allSignatures);
        this.prepareDetachedTimestampValidationContext(validationContext, detachedTimestamps);
        this.populateFromDssDictionaries(validationContext, dssDictionaries);
        if (!this.skipValidationContextExecution) {
            this.validateContext(validationContext);
        }
        return this.getDiagnosticDataBuilderConfiguration(validationContext, allSignatures, listCRLSource, listOCSPSource);
    }

    protected ListRevocationSource<CRL> mergeCRLSources(Collection<AdvancedSignature> allSignatures, Collection<TimestampToken> timestampTokens, Collection<PdfDssDict> dssDictionaries) {
        ListRevocationSource listCRLSource = this.mergeCRLSources(allSignatures, timestampTokens);
        if (Utils.isCollectionNotEmpty(dssDictionaries)) {
            for (PdfDssDict dssDictionary : dssDictionaries) {
                listCRLSource.add((OfflineRevocationSource)new PAdESCRLSource(dssDictionary));
            }
        }
        return listCRLSource;
    }

    protected ListRevocationSource<OCSP> mergeOCSPSources(Collection<AdvancedSignature> allSignatures, Collection<TimestampToken> timestampTokens, Collection<PdfDssDict> dssDictionaries) {
        ListRevocationSource listOCSPSource = this.mergeOCSPSources(allSignatures, timestampTokens);
        if (Utils.isCollectionNotEmpty(dssDictionaries)) {
            for (PdfDssDict dssDictionary : dssDictionaries) {
                listOCSPSource.add((OfflineRevocationSource)new PAdESOCSPSource(dssDictionary));
            }
        }
        return listOCSPSource;
    }

    protected void populateFromDssDictionaries(ValidationContext validationContext, List<PdfDssDict> dssDicts) {
        for (PdfDssDict dssDict : dssDicts) {
            for (CertificateToken certificateToken : dssDict.getCERTs().values()) {
                validationContext.addCertificateTokenForVerification(certificateToken);
            }
        }
    }

    protected ListCertificateSource mergeCertificateSource(Collection<AdvancedSignature> allSignatureList, Collection<TimestampToken> detachedTimestamps, List<PdfDssDict> dssDictionaries) {
        ListCertificateSource allCertificatesSource = this.mergeCertificateSource(allSignatureList, detachedTimestamps);
        return allCertificatesSource;
    }

    public List<AdvancedSignature> getSignatures() {
        ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        for (PdfRevision pdfRevision : this.getRevisions()) {
            if (!(pdfRevision instanceof PdfSignatureRevision)) continue;
            PdfSignatureRevision pdfSignatureRevision = (PdfSignatureRevision)pdfRevision;
            try {
                PAdESSignature padesSignature = new PAdESSignature(pdfSignatureRevision, this.documentRevisions);
                padesSignature.setSignatureFilename(this.document.getName());
                padesSignature.setProvidedSigningCertificateToken(this.providedSigningCertificateToken);
                padesSignature.prepareOfflineCertificateVerifier(this.certificateVerifier);
                signatures.add((AdvancedSignature)padesSignature);
            }
            catch (Exception e) {
                throw new DSSException(String.format("Unable to collect a signature. Reason : [%s]", e.getMessage()), (Throwable)e);
            }
        }
        Collections.reverse(signatures);
        return signatures;
    }

    public List<TimestampToken> getDetachedTimestamps() {
        ArrayList<TimestampToken> timestamps = new ArrayList<TimestampToken>();
        for (PdfRevision pdfRevision : this.getRevisions()) {
            if (!(pdfRevision instanceof PdfDocTimestampRevision)) continue;
            PdfDocTimestampRevision pdfDocTimestampRevision = (PdfDocTimestampRevision)pdfRevision;
            try {
                TimestampToken timestampToken = new TimestampToken((PdfRevision)pdfDocTimestampRevision, TimestampType.CONTENT_TIMESTAMP, TimestampLocation.DOC_TIMESTAMP);
                timestampToken.setFileName(this.document.getName());
                timestampToken.matchData((DSSDocument)new InMemoryDocument(pdfDocTimestampRevision.getRevisionCoveredBytes()));
                PAdESSignatureScopeFinder signatureScopeFinder = new PAdESSignatureScopeFinder();
                signatureScopeFinder.setDefaultDigestAlgorithm(this.getDefaultDigestAlgorithm());
                timestampToken.setTimestampScopes(Arrays.asList(signatureScopeFinder.findSignatureScope(pdfDocTimestampRevision)));
                timestamps.add(timestampToken);
            }
            catch (Exception e) {
                throw new DSSException(String.format("Unable to collect a timestamp. Reason : [%s]", e.getMessage()), (Throwable)e);
            }
        }
        Collections.reverse(timestamps);
        return timestamps;
    }

    public List<PdfDssDict> getDssDictionaries() {
        ArrayList<PdfDssDict> docDssRevisions = new ArrayList<PdfDssDict>();
        for (PdfRevision pdfRevision : this.getRevisions()) {
            if (!(pdfRevision instanceof PdfDocDssRevision)) continue;
            PdfDocDssRevision dssRevision = (PdfDocDssRevision)pdfRevision;
            docDssRevisions.add(dssRevision.getDssDictionary());
        }
        Collections.reverse(docDssRevisions);
        return docDssRevisions;
    }

    protected List<PdfRevision> getRevisions() {
        if (this.documentRevisions == null) {
            PDFSignatureService pdfSignatureService = this.pdfObjectFactory.newPAdESSignatureService();
            this.documentRevisions = pdfSignatureService.getRevisions(this.document, this.passwordProtection);
        }
        return this.documentRevisions;
    }

    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        Objects.requireNonNull(signatureId, "Signature Id cannot be null");
        List<AdvancedSignature> signatures = this.getSignatures();
        for (AdvancedSignature signature : signatures) {
            if (!signature.getId().equals(signatureId)) continue;
            return this.getOriginalDocuments(signature);
        }
        return Collections.emptyList();
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        PAdESSignature padesSignature = (PAdESSignature)advancedSignature;
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        InMemoryDocument originalPDF = PAdESUtils.getOriginalPDF(padesSignature);
        if (originalPDF != null) {
            result.add((DSSDocument)originalPDF);
        }
        return result;
    }
}

