/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.enumerations.TimestampLocation;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pdf.PdfCMSRevision;
import eu.europa.esig.dss.validation.PdfRevision;
import eu.europa.esig.dss.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfDocTimestampRevision
extends PdfCMSRevision {
    private static final Logger LOG = LoggerFactory.getLogger(PdfDocTimestampRevision.class);
    private final TimestampToken timestampToken;

    public PdfDocTimestampRevision(PdfSignatureDictionary signatureDictionary, List<String> timestampFieldNames, byte[] signedContent, boolean coverCompleteRevision, boolean isArchiveTimestamp) {
        super(signatureDictionary, timestampFieldNames, signedContent, coverCompleteRevision);
        try {
            TimestampType timestampType = isArchiveTimestamp ? TimestampType.ARCHIVE_TIMESTAMP : TimestampType.SIGNATURE_TIMESTAMP;
            this.timestampToken = new TimestampToken((PdfRevision)this, timestampType, TimestampLocation.DOC_TIMESTAMP);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created PdfDocTimestampInfo {} : {}", (Object)timestampType, (Object)this.getByteRange());
            }
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    @Override
    public Date getSigningDate() {
        return this.timestampToken.getGenerationTime();
    }

    public TimestampToken getTimestampToken() {
        return this.timestampToken;
    }
}

