/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.cades.signature.CAdESTimestampParameters;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.pades.PAdESCommonParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import java.util.Date;

public class PAdESTimestampParameters
extends CAdESTimestampParameters
implements PAdESCommonParameters {
    protected Date timestampDate = new Date();
    private int timestampSize = 9472;
    private String timestampFilter = "Adobe.PPKLite";
    private String timestampSubFilter = "ETSI.RFC3161";
    private SignatureImageParameters timestampImageParameters;
    private String passwordProtection;

    public PAdESTimestampParameters() {
    }

    public PAdESTimestampParameters(DigestAlgorithm digestAlgorithm) {
        super(digestAlgorithm);
    }

    PAdESTimestampParameters(CAdESTimestampParameters cadesTimestampParameters) {
        this(cadesTimestampParameters.getDigestAlgorithm());
    }

    @Override
    public String getFilter() {
        return this.timestampFilter;
    }

    public void setFilter(String timestampFilter) {
        this.timestampFilter = timestampFilter;
    }

    @Override
    public String getSubFilter() {
        return this.timestampSubFilter;
    }

    public void setSubFilter(String timestampSubFilter) {
        this.timestampSubFilter = timestampSubFilter;
    }

    @Override
    public SignatureImageParameters getImageParameters() {
        if (this.timestampImageParameters == null) {
            this.timestampImageParameters = new SignatureImageParameters();
        }
        return this.timestampImageParameters;
    }

    public void setImageParameters(SignatureImageParameters timestampImageParameters) {
        this.timestampImageParameters = timestampImageParameters;
    }

    @Override
    public int getContentSize() {
        return this.timestampSize;
    }

    public void setContentSize(int timestampSize) {
        this.timestampSize = timestampSize;
    }

    @Override
    public Date getSigningDate() {
        return this.timestampDate;
    }

    @Deprecated
    public void setFieldId(String timestampFieldId) {
        this.getImageParameters().getFieldParameters().setFieldId(timestampFieldId);
    }

    @Override
    public String getPasswordProtection() {
        return this.passwordProtection;
    }

    public void setPasswordProtection(String passwordProtection) {
        this.passwordProtection = passwordProtection;
    }
}

