/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineT;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PDFDocumentValidator;
import eu.europa.esig.dss.pdf.DSSDictionaryCallback;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.ValidationDataForInclusion;
import eu.europa.esig.dss.validation.ValidationDataForInclusionBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class PAdESLevelBaselineLT
extends PAdESLevelBaselineT {
    private final CertificateVerifier certificateVerifier;

    PAdESLevelBaselineLT(TSPSource tspSource, CertificateVerifier certificateVerifier, IPdfObjFactory pdfObjectFactory) {
        super(tspSource, pdfObjectFactory);
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public DSSDocument extendSignatures(DSSDocument document, PAdESSignatureParameters parameters) {
        this.assertExtensionPossible(document);
        PDFDocumentValidator pdfDocumentValidator = this.getPDFDocumentValidator(document, parameters);
        List<AdvancedSignature> signatures = pdfDocumentValidator.getSignatures();
        if (Utils.isCollectionEmpty(signatures)) {
            throw new DSSException("No signatures found to be extended!");
        }
        for (AdvancedSignature advancedSignature : signatures) {
            if (!this.requiresDocumentTimestamp(advancedSignature)) continue;
            document = super.extendSignatures(document, parameters);
            pdfDocumentValidator = this.getPDFDocumentValidator(document, parameters);
            break;
        }
        signatures = pdfDocumentValidator.getSignatures();
        LinkedList<DSSDictionaryCallback> callbacks = new LinkedList<DSSDictionaryCallback>();
        for (AdvancedSignature signature : signatures) {
            if (!(signature instanceof PAdESSignature)) continue;
            PAdESSignature padesSignature = (PAdESSignature)signature;
            this.assertExtendSignaturePossible(padesSignature);
            callbacks.add(this.validate(padesSignature));
        }
        PDFSignatureService pDFSignatureService = this.newPdfSignatureService();
        return pDFSignatureService.addDssDictionary(document, callbacks, parameters.getPasswordProtection());
    }

    private PDFDocumentValidator getPDFDocumentValidator(DSSDocument document, PAdESSignatureParameters parameters) {
        PDFDocumentValidator pdfDocumentValidator = new PDFDocumentValidator(document);
        pdfDocumentValidator.setCertificateVerifier(this.certificateVerifier);
        pdfDocumentValidator.setPasswordProtection(parameters.getPasswordProtection());
        return pdfDocumentValidator;
    }

    private boolean requiresDocumentTimestamp(AdvancedSignature signature) {
        ArrayList timestamps = new ArrayList(signature.getSignatureTimestamps());
        timestamps.addAll(signature.getArchiveTimestamps());
        timestamps.addAll(signature.getDocumentTimestamps());
        return Utils.isCollectionEmpty(timestamps);
    }

    private void assertExtendSignaturePossible(PAdESSignature padesSignature) throws DSSException {
        if (padesSignature.areAllSelfSignedCertificates()) {
            throw new DSSException("Cannot extend the signature. The signature contains only self-signed certificate chains!");
        }
    }

    protected DSSDictionaryCallback validate(PAdESSignature signature) {
        ValidationContext validationContext = signature.getSignatureValidationContext(this.certificateVerifier);
        ValidationDataForInclusionBuilder validationDataForInclusionBuilder = new ValidationDataForInclusionBuilder(validationContext, signature.getCompleteCertificateSource());
        ValidationDataForInclusion validationDataForInclusion = validationDataForInclusionBuilder.build();
        DSSDictionaryCallback validationCallback = new DSSDictionaryCallback();
        validationCallback.setSignature(signature);
        Set certificatesForInclusion = validationDataForInclusion.getCertificateTokens();
        validationCallback.setCertificates(certificatesForInclusion);
        validationCallback.setCrls(validationDataForInclusion.getCrlTokens());
        validationCallback.setOcsps(validationDataForInclusion.getOcspTokens());
        return validationCallback;
    }
}

