/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESCertificateSource;
import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.validation.PdfDssDictCertificateSource;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bouncycastle.cms.SignerInformation;

public class PAdESCertificateSource
extends CAdESCertificateSource {
    private final PdfDssDictCertificateSource dssDictionaryCertificateSource;

    public PAdESCertificateSource(PdfSignatureRevision pdfSignatureRevision, SignerInformation signerInformation) {
        super(pdfSignatureRevision.getCMSSignedData(), signerInformation);
        this.dssDictionaryCertificateSource = new PdfDssDictCertificateSource(pdfSignatureRevision.getDssDictionary());
        this.extractFromDssDictSource();
    }

    private void extractFromDssDictSource() {
        for (CertificateToken certToken : this.dssDictionaryCertificateSource.getDSSDictionaryCertValues()) {
            this.addCertificate(certToken, CertificateOrigin.DSS_DICTIONARY);
        }
        for (CertificateToken certToken : this.dssDictionaryCertificateSource.getVRIDictionaryCertValues()) {
            this.addCertificate(certToken, CertificateOrigin.VRI_DICTIONARY);
        }
    }

    public Map<Long, CertificateToken> getCertificateMap() {
        return this.dssDictionaryCertificateSource.getCertificateMap();
    }

    public List<CertificateToken> getCertificateValues() {
        return Collections.emptyList();
    }

    public List<CertificateRef> getCompleteCertificateRefs() {
        return Collections.emptyList();
    }

    public List<CertificateRef> getAttributeCertificateRefs() {
        return Collections.emptyList();
    }

    public List<CertificateToken> getDSSDictionaryCertValues() {
        return this.dssDictionaryCertificateSource.getDSSDictionaryCertValues();
    }

    public List<CertificateToken> getVRIDictionaryCertValues() {
        return this.dssDictionaryCertificateSource.getVRIDictionaryCertValues();
    }
}

