/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESDiagnosticDataBuilder;
import eu.europa.esig.dss.diagnostic.jaxb.XmlModification;
import eu.europa.esig.dss.diagnostic.jaxb.XmlModificationDetection;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanTokens;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFRevision;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFSignatureDictionary;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestamp;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfModification;
import eu.europa.esig.dss.pades.validation.PdfModificationDetection;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pades.validation.timestamp.PdfTimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class PAdESDiagnosticDataBuilder
extends CAdESDiagnosticDataBuilder {
    public XmlSignature buildDetachedXmlSignature(AdvancedSignature signature) {
        XmlSignature xmlSignature = super.buildDetachedXmlSignature(signature);
        PAdESSignature padesSignature = (PAdESSignature)signature;
        xmlSignature.setPDFRevision(this.getXmlPDFRevision(padesSignature.getPdfRevision()));
        return xmlSignature;
    }

    protected XmlTimestamp buildDetachedXmlTimestamp(TimestampToken timestampToken) {
        XmlTimestamp xmlTimestamp = super.buildDetachedXmlTimestamp(timestampToken);
        if (timestampToken instanceof PdfTimestampToken) {
            PdfTimestampToken pdfTimestampToken = (PdfTimestampToken)timestampToken;
            xmlTimestamp.setPDFRevision(this.getXmlPDFRevision(pdfTimestampToken.getPdfRevision()));
        }
        return xmlTimestamp;
    }

    private XmlPDFRevision getXmlPDFRevision(PdfRevision pdfRevision) {
        if (pdfRevision != null) {
            XmlPDFRevision xmlPDFRevision = new XmlPDFRevision();
            xmlPDFRevision.getSignatureFieldName().addAll(pdfRevision.getFieldNames());
            xmlPDFRevision.setPDFSignatureDictionary(this.getXmlPDFSignatureDictionary(pdfRevision.getPdfSigDictInfo()));
            xmlPDFRevision.setModificationDetection(this.getXmlModificationDetection(pdfRevision.getModificationDetection()));
            return xmlPDFRevision;
        }
        return null;
    }

    private XmlPDFSignatureDictionary getXmlPDFSignatureDictionary(PdfSignatureDictionary pdfSigDict) {
        if (pdfSigDict != null) {
            XmlPDFSignatureDictionary pdfSignatureDictionary = new XmlPDFSignatureDictionary();
            pdfSignatureDictionary.setSignerName(this.emptyToNull(pdfSigDict.getSignerName()));
            pdfSignatureDictionary.setType(this.emptyToNull(pdfSigDict.getType()));
            pdfSignatureDictionary.setFilter(this.emptyToNull(pdfSigDict.getFilter()));
            pdfSignatureDictionary.setSubFilter(this.emptyToNull(pdfSigDict.getSubFilter()));
            pdfSignatureDictionary.setContactInfo(this.emptyToNull(pdfSigDict.getContactInfo()));
            pdfSignatureDictionary.setLocation(this.emptyToNull(pdfSigDict.getLocation()));
            pdfSignatureDictionary.setReason(this.emptyToNull(pdfSigDict.getReason()));
            pdfSignatureDictionary.getSignatureByteRange().addAll(pdfSigDict.getByteRange().toBigIntegerList());
            return pdfSignatureDictionary;
        }
        return null;
    }

    private XmlModificationDetection getXmlModificationDetection(PdfModificationDetection modificationDetection) {
        if (modificationDetection != null && modificationDetection.areModificationsDetected()) {
            List<PdfModification> pageDifferences;
            List<PdfModification> visualDifferences;
            XmlModificationDetection xmlModificationDetection = new XmlModificationDetection();
            List<PdfModification> annotationOverlaps = modificationDetection.getAnnotationOverlaps();
            if (Utils.isCollectionNotEmpty(annotationOverlaps)) {
                xmlModificationDetection.getAnnotationOverlap().addAll(this.getXmlModifications(annotationOverlaps));
            }
            if (Utils.isCollectionNotEmpty(visualDifferences = modificationDetection.getVisualDifferences())) {
                xmlModificationDetection.getVisualDifference().addAll(this.getXmlModifications(visualDifferences));
            }
            if (Utils.isCollectionNotEmpty(pageDifferences = modificationDetection.getPageDifferences())) {
                xmlModificationDetection.getPageDifference().addAll(this.getXmlModifications(pageDifferences));
            }
            return xmlModificationDetection;
        }
        return null;
    }

    private List<XmlModification> getXmlModifications(List<PdfModification> modifications) {
        ArrayList<XmlModification> xmlModifications = new ArrayList<XmlModification>();
        if (Utils.isCollectionNotEmpty(modifications)) {
            for (PdfModification pdfModification : modifications) {
                xmlModifications.add(this.getXmlModification(pdfModification));
            }
        }
        return xmlModifications;
    }

    private XmlModification getXmlModification(PdfModification pdfModification) {
        XmlModification xmlModification = new XmlModification();
        xmlModification.setPage(BigInteger.valueOf(pdfModification.getPage()));
        return xmlModification;
    }

    protected XmlOrphanTokens buildXmlOrphanTokens() {
        this.buildOrphanRevocationTokensFromCommonSources();
        return super.buildXmlOrphanTokens();
    }

    private void buildOrphanRevocationTokensFromCommonSources() {
        String id;
        for (EncapsulatedRevocationTokenIdentifier revocationIdentifier : this.commonCRLSource.getAllRevocationBinaries()) {
            id = revocationIdentifier.asXmlId();
            if (this.xmlRevocationsMap.containsKey(id) || this.xmlOrphanRevocationTokensMap.containsKey(id)) continue;
            this.createOrphanTokenFromRevocationIdentifier(revocationIdentifier);
        }
        for (EncapsulatedRevocationTokenIdentifier revocationIdentifier : this.commonOCSPSource.getAllRevocationBinaries()) {
            id = revocationIdentifier.asXmlId();
            if (this.xmlRevocationsMap.containsKey(id) || this.xmlOrphanRevocationTokensMap.containsKey(id)) continue;
            this.createOrphanTokenFromRevocationIdentifier(revocationIdentifier);
        }
    }
}

