/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.validation.PAdESCRLSource;
import eu.europa.esig.dss.pades.validation.PAdESCertificateSource;
import eu.europa.esig.dss.pades.validation.PAdESOCSPSource;
import eu.europa.esig.dss.pades.validation.PAdESSignatureIdentifierBuilder;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pades.validation.timestamp.PAdESTimestampSource;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureDigestReference;
import eu.europa.esig.dss.validation.SignatureIdentifierBuilder;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.bouncycastle.cms.CMSSignedData;

public class PAdESSignature
extends CAdESSignature {
    private static final long serialVersionUID = 3818555396958720967L;
    private final PdfSignatureRevision pdfSignatureRevision;
    private final List<PdfRevision> documentRevisions;

    protected PAdESSignature(PdfSignatureRevision pdfSignatureRevision, List<PdfRevision> documentRevisions) {
        super(pdfSignatureRevision.getCMSSignedData(), DSSASN1Utils.getFirstSignerInformation((CMSSignedData)pdfSignatureRevision.getCMSSignedData()));
        this.pdfSignatureRevision = pdfSignatureRevision;
        this.documentRevisions = documentRevisions;
        this.detachedContents = Arrays.asList(new InMemoryDocument(pdfSignatureRevision.getRevisionCoveredBytes()));
    }

    public SignatureForm getSignatureForm() {
        if (this.hasPKCS7SubFilter()) {
            return SignatureForm.PKCS7;
        }
        return SignatureForm.PAdES;
    }

    public SignatureCertificateSource getCertificateSource() {
        if (this.offlineCertificateSource == null) {
            this.offlineCertificateSource = new PAdESCertificateSource(this.pdfSignatureRevision, this.getSignerInformation());
        }
        return this.offlineCertificateSource;
    }

    public OfflineCRLSource getCRLSource() {
        if (this.signatureCRLSource == null) {
            this.signatureCRLSource = new PAdESCRLSource(this.pdfSignatureRevision.getDssDictionary(), this.getVRIKey(), this.getSignerInformation().getSignedAttributes());
        }
        return this.signatureCRLSource;
    }

    public OfflineOCSPSource getOCSPSource() {
        if (this.signatureOCSPSource == null) {
            this.signatureOCSPSource = new PAdESOCSPSource(this.pdfSignatureRevision.getDssDictionary(), this.getVRIKey(), this.getSignerInformation().getSignedAttributes());
        }
        return this.signatureOCSPSource;
    }

    public PAdESTimestampSource getTimestampSource() {
        if (this.signatureTimestampSource == null) {
            this.signatureTimestampSource = new PAdESTimestampSource(this, this.documentRevisions);
        }
        return (PAdESTimestampSource)this.signatureTimestampSource;
    }

    public Date getSigningTime() {
        return this.pdfSignatureRevision.getSigningDate();
    }

    public String getContentIdentifier() {
        return null;
    }

    public String getContentHints() {
        return null;
    }

    public List<AdvancedSignature> getCounterSignatures() {
        return Collections.emptyList();
    }

    protected SignatureIdentifierBuilder getSignatureIdentifierBuilder() {
        return new PAdESSignatureIdentifierBuilder(this);
    }

    public SignatureDigestReference getSignatureDigestReference(DigestAlgorithm digestAlgorithm) {
        byte[] contents = this.getPdfSignatureDictionary().getContents();
        byte[] digestValue = DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])contents);
        return new SignatureDigestReference(new Digest(digestAlgorithm, digestValue));
    }

    public SignatureLevel getDataFoundUpToLevel() {
        if (this.hasCAdESDetachedSubFilter()) {
            if (this.hasLTProfile() && this.hasDSSDictionary()) {
                if (this.hasLTAProfile()) {
                    return SignatureLevel.PAdES_BASELINE_LTA;
                }
                if (this.hasTProfile()) {
                    return SignatureLevel.PAdES_BASELINE_LT;
                }
            }
            if (this.hasTProfile()) {
                return SignatureLevel.PAdES_BASELINE_T;
            }
            return SignatureLevel.PAdES_BASELINE_B;
        }
        if (this.hasPKCS7SubFilter()) {
            if (this.hasLTProfile()) {
                if (this.hasLTAProfile()) {
                    return SignatureLevel.PKCS7_LTA;
                }
                if (this.hasTProfile()) {
                    return SignatureLevel.PKCS7_LT;
                }
            }
            if (this.hasTProfile()) {
                return SignatureLevel.PKCS7_T;
            }
            return SignatureLevel.PKCS7_B;
        }
        return SignatureLevel.PDF_NOT_ETSI;
    }

    public boolean hasTProfile() {
        if (super.hasTProfile()) {
            return true;
        }
        return Utils.isCollectionNotEmpty((Collection)this.getDocumentTimestamps());
    }

    public boolean hasLTAProfile() {
        List documentTimestamps = this.getDocumentTimestamps();
        if (Utils.isCollectionNotEmpty((Collection)documentTimestamps)) {
            for (TimestampToken timestampToken : documentTimestamps) {
                if (!this.coversLTLevelData(timestampToken)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean coversLTLevelData(TimestampToken timestampToken) {
        return ArchiveTimestampType.PAdES.equals((Object)timestampToken.getArchiveTimestampType());
    }

    private boolean hasDSSDictionary() {
        return this.getDssDictionary() != null;
    }

    public PdfDssDict getDssDictionary() {
        return this.pdfSignatureRevision.getDssDictionary();
    }

    private boolean hasCAdESDetachedSubFilter() {
        return this.pdfSignatureRevision != null && "ETSI.CAdES.detached".equals(this.pdfSignatureRevision.getPdfSigDictInfo().getSubFilter());
    }

    private boolean hasPKCS7SubFilter() {
        return this.pdfSignatureRevision != null && "adbe.pkcs7.detached".equals(this.pdfSignatureRevision.getPdfSigDictInfo().getSubFilter());
    }

    public PdfSignatureRevision getPdfRevision() {
        return this.pdfSignatureRevision;
    }

    public PdfSignatureDictionary getPdfSignatureDictionary() {
        return this.pdfSignatureRevision.getPdfSigDictInfo();
    }

    public String getVRIKey() {
        byte[] digest = DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA1, (byte[])this.getPdfSignatureDictionary().getContents());
        String vriId = Utils.toHex((byte[])digest);
        return vriId.toUpperCase();
    }
}

