/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class PdfDssDictOCSPSource
extends OfflineOCSPSource {
    private transient Map<Long, BasicOCSPResp> ocspMap;

    public PdfDssDictOCSPSource(PdfDssDict dssDictionary) {
        this.extractDSSOCSPs(dssDictionary);
        this.extractVRIOCSPs(dssDictionary);
    }

    PdfDssDictOCSPSource() {
    }

    public Map<Long, BasicOCSPResp> getOcspMap() {
        if (this.ocspMap != null) {
            return this.ocspMap;
        }
        return Collections.emptyMap();
    }

    private Map<Long, BasicOCSPResp> getDssOcspMap(PdfDssDict dssDictionary) {
        if (dssDictionary != null) {
            this.ocspMap = dssDictionary.getOCSPs();
            return this.ocspMap;
        }
        return Collections.emptyMap();
    }

    protected void extractDSSOCSPs(PdfDssDict dssDictionary) {
        Map<Long, BasicOCSPResp> dssOcspMap = this.getDssOcspMap(dssDictionary);
        for (BasicOCSPResp basicOCSPResp : dssOcspMap.values()) {
            this.addBinary((EncapsulatedRevocationTokenIdentifier)OCSPResponseBinary.build((BasicOCSPResp)basicOCSPResp), RevocationOrigin.DSS_DICTIONARY);
        }
    }

    protected void extractVRIOCSPs(PdfDssDict dssDictionary) {
        List<PdfVRIDict> vriDictList;
        if (dssDictionary != null && Utils.isCollectionNotEmpty(vriDictList = dssDictionary.getVRIs())) {
            for (PdfVRIDict vriDict : vriDictList) {
                this.extractVRIOCSPs(vriDict);
            }
        }
    }

    protected void extractVRIOCSPs(PdfVRIDict vriDictionary) {
        if (vriDictionary != null) {
            for (Map.Entry<Long, BasicOCSPResp> ocspEntry : vriDictionary.getOCSPs().entrySet()) {
                if (!this.ocspMap.containsKey(ocspEntry.getKey())) {
                    this.ocspMap.put(ocspEntry.getKey(), ocspEntry.getValue());
                }
                this.addBinary((EncapsulatedRevocationTokenIdentifier)OCSPResponseBinary.build((BasicOCSPResp)ocspEntry.getValue()), RevocationOrigin.VRI_DICTIONARY);
            }
        }
    }
}

