/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.timestamp;

import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.timestamp.CAdESTimestampSource;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfDssDictCRLSource;
import eu.europa.esig.dss.pades.validation.PdfDssDictCertificateSource;
import eu.europa.esig.dss.pades.validation.PdfDssDictOCSPSource;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pades.validation.timestamp.PAdESTimestampDataBuilder;
import eu.europa.esig.dss.pades.validation.timestamp.PdfRevisionTimestampSource;
import eu.europa.esig.dss.pdf.PdfDocDssRevision;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PAdESTimestampSource
extends CAdESTimestampSource {
    private final transient List<PdfRevision> documentRevisions;
    protected List<TimestampToken> documentTimestamps;

    public PAdESTimestampSource(PAdESSignature signature, List<PdfRevision> documentRevisions) {
        super((CAdESSignature)signature);
        Objects.requireNonNull(documentRevisions, "List of Document revisions must be provided!");
        this.documentRevisions = Utils.reverseList(documentRevisions);
    }

    public List<TimestampToken> getDocumentTimestamps() {
        if (this.documentTimestamps == null) {
            this.createAndValidate();
        }
        return this.documentTimestamps;
    }

    protected PAdESTimestampDataBuilder getTimestampDataBuilder() {
        PAdESTimestampDataBuilder padesTimestampDataBuilder = new PAdESTimestampDataBuilder(this.documentRevisions, (PAdESSignature)this.signature, this.certificateSource);
        padesTimestampDataBuilder.setSignatureTimestamps(this.getSignatureTimestamps());
        return padesTimestampDataBuilder;
    }

    protected void makeTimestampTokensFromSignedAttributes() {
        if (this.signature != null) {
            super.makeTimestampTokensFromSignedAttributes();
        }
    }

    protected void makeTimestampTokensFromUnsignedAttributes() {
        super.makeTimestampTokensFromUnsignedAttributes();
        List cadesSignatureTimestamps = this.getSignatureTimestamps();
        ArrayList<TimestampToken> timestampedTimestamps = new ArrayList<TimestampToken>(cadesSignatureTimestamps);
        this.unsignedPropertiesReferences = new ArrayList();
        this.documentTimestamps = new ArrayList<TimestampToken>();
        boolean signatureRevisionReached = false;
        boolean dssRevisionReached = false;
        for (PdfRevision pdfRevision : this.documentRevisions) {
            PAdESSignature padesSignature;
            if (pdfRevision instanceof PdfDocTimestampRevision) {
                ArrayList individualTimestampReferences = new ArrayList();
                PdfDocTimestampRevision timestampRevision = (PdfDocTimestampRevision)pdfRevision;
                TimestampToken timestampToken = timestampRevision.getTimestampToken();
                if (dssRevisionReached) {
                    timestampToken.setArchiveTimestampType(ArchiveTimestampType.PAdES);
                }
                if (signatureRevisionReached) {
                    this.addReferences(individualTimestampReferences, this.getSignatureTimestampReferences());
                    this.addReferences(individualTimestampReferences, this.getSignatureSignedDataReferences());
                }
                if (Utils.isCollectionNotEmpty((Collection)this.unsignedPropertiesReferences)) {
                    this.addReferences(individualTimestampReferences, this.unsignedPropertiesReferences);
                }
                this.addReferences(individualTimestampReferences, this.getEncapsulatedReferencesFromTimestamps(timestampedTimestamps));
                this.addReferences(timestampToken.getTimestampedReferences(), individualTimestampReferences);
                if (signatureRevisionReached) {
                    this.documentTimestamps.add(timestampToken);
                }
                this.populateSources(timestampToken);
                timestampedTimestamps.add(timestampToken);
                continue;
            }
            if (pdfRevision instanceof PdfDocDssRevision) {
                PdfDocDssRevision pdfDocDssRevision = (PdfDocDssRevision)pdfRevision;
                PdfRevisionTimestampSource pdfRevisionTimestampSource = new PdfRevisionTimestampSource(pdfDocDssRevision);
                this.addReferences(this.unsignedPropertiesReferences, pdfRevisionTimestampSource.getIncorporatedReferences());
                PdfDssDict dssDictionary = pdfDocDssRevision.getDssDictionary();
                this.certificateSource.add((CertificateSource)new PdfDssDictCertificateSource(dssDictionary));
                this.crlSource.add((OfflineRevocationSource)new PdfDssDictCRLSource(dssDictionary));
                this.ocspSource.add((OfflineRevocationSource)new PdfDssDictOCSPSource(dssDictionary));
                dssRevisionReached = true;
                continue;
            }
            if (!(pdfRevision instanceof PdfSignatureRevision) || (padesSignature = (PAdESSignature)this.signature).getPdfRevision() != pdfRevision) continue;
            signatureRevisionReached = true;
        }
    }

    protected boolean isCompleteCertificateRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isAttributeCertificateRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isCompleteRevocationRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isAttributeRevocationRef(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isRefsOnlyTimestamp(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isSigAndRefsTimestamp(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isCertificateValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isRevocationValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isArchiveTimestamp(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected List<AdvancedSignature> getCounterSignatures(CAdESAttribute unsignedAttribute) {
        return Collections.emptyList();
    }
}

