/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.timestamp;

import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.pades.validation.PdfDssDictCRLSource;
import eu.europa.esig.dss.pades.validation.PdfDssDictCertificateSource;
import eu.europa.esig.dss.pades.validation.PdfDssDictOCSPSource;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pdf.PdfDocDssRevision;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.validation.timestamp.AbstractTimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PdfRevisionTimestampSource
extends AbstractTimestampSource {
    public final PdfRevision pdfRevision;

    public PdfRevisionTimestampSource(PdfRevision pdfRevision) {
        this.pdfRevision = pdfRevision;
    }

    public List<TimestampedReference> getIncorporatedReferences() {
        if (this.pdfRevision instanceof PdfDocTimestampRevision) {
            PdfDocTimestampRevision pdfDocTimestampRevision = (PdfDocTimestampRevision)this.pdfRevision;
            TimestampToken timestampToken = pdfDocTimestampRevision.getTimestampToken();
            return this.getReferencesFromTimestamp(timestampToken);
        }
        if (this.pdfRevision instanceof PdfDocDssRevision) {
            PdfDocDssRevision pdfDocDssRevision = (PdfDocDssRevision)this.pdfRevision;
            PdfDssDict dssDictionary = pdfDocDssRevision.getDssDictionary();
            ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
            PdfDssDictCertificateSource certificateSource = new PdfDssDictCertificateSource(dssDictionary);
            this.addReferences(references, this.createReferencesForCertificates(certificateSource.getCertificates()));
            PdfDssDictCRLSource crlSource = new PdfDssDictCRLSource(dssDictionary);
            this.addReferences(references, this.createReferencesForIdentifiers(crlSource.getDSSDictionaryBinaries(), TimestampedObjectType.REVOCATION));
            this.addReferences(references, this.createReferencesForIdentifiers(crlSource.getVRIDictionaryBinaries(), TimestampedObjectType.REVOCATION));
            PdfDssDictOCSPSource ocspSource = new PdfDssDictOCSPSource(dssDictionary);
            this.addReferences(references, this.createReferencesForIdentifiers(ocspSource.getDSSDictionaryBinaries(), TimestampedObjectType.REVOCATION));
            this.addReferences(references, this.createReferencesForIdentifiers(ocspSource.getVRIDictionaryBinaries(), TimestampedObjectType.REVOCATION));
            return references;
        }
        return Collections.emptyList();
    }
}

