/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.alert.ExceptionOnStatusAlert;
import eu.europa.esig.dss.alert.StatusAlert;
import eu.europa.esig.dss.alert.status.Status;
import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.exception.InvalidPasswordException;
import eu.europa.esig.dss.pades.validation.PdfModification;
import eu.europa.esig.dss.pades.validation.PdfModificationDetection;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.DSSDictionaryCallback;
import eu.europa.esig.dss.pdf.PDFServiceMode;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PdfAnnotation;
import eu.europa.esig.dss.pdf.PdfCMSRevision;
import eu.europa.esig.dss.pdf.PdfDocDssRevision;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfModificationDetectionImpl;
import eu.europa.esig.dss.pdf.PdfModificationDetectionUtils;
import eu.europa.esig.dss.pdf.PdfSignatureDictionaryComparator;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.pdf.visible.SignatureDrawer;
import eu.europa.esig.dss.pdf.visible.SignatureDrawerFactory;
import eu.europa.esig.dss.pdf.visible.SignatureFieldBoxBuilder;
import eu.europa.esig.dss.pdf.visible.VisualSignatureFieldAppearance;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ByteRange;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPDFSignatureService
implements PDFSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPDFSignatureService.class);
    private final PDFServiceMode serviceMode;
    private final SignatureDrawerFactory signatureDrawerFactory;
    private StatusAlert alertOnSignatureFieldOverlap = new ExceptionOnStatusAlert();
    private int maximalPagesAmountForVisualComparison = 10;

    protected AbstractPDFSignatureService(PDFServiceMode serviceMode, SignatureDrawerFactory signatureDrawerFactory) {
        Objects.requireNonNull(serviceMode, "The PDFServiceMode shall be defined!");
        Objects.requireNonNull(signatureDrawerFactory, "The SignatureDrawerFactory shall be defined!");
        this.serviceMode = serviceMode;
        this.signatureDrawerFactory = signatureDrawerFactory;
    }

    public void setAlertOnSignatureFieldOverlap(StatusAlert alertOnSignatureFieldOverlap) {
        Objects.requireNonNull(alertOnSignatureFieldOverlap, "StatusAlert cannot be null!");
        this.alertOnSignatureFieldOverlap = alertOnSignatureFieldOverlap;
    }

    public void setMaximalPagesAmountForVisualComparison(int pagesAmount) {
        this.maximalPagesAmountForVisualComparison = pagesAmount;
    }

    protected SignatureDrawer loadSignatureDrawer(SignatureImageParameters imageParameters) {
        SignatureDrawer signatureDrawer = this.signatureDrawerFactory.getSignatureDrawer(imageParameters);
        if (signatureDrawer == null) {
            throw new DSSException("SignatureDrawer shall be defined for the used SignatureDrawerFactory!");
        }
        return signatureDrawer;
    }

    protected boolean isDocumentTimestampLayer() {
        return PDFServiceMode.SIGNATURE_TIMESTAMP == this.serviceMode || PDFServiceMode.ARCHIVE_TIMESTAMP == this.serviceMode;
    }

    protected String getType() {
        if (this.isDocumentTimestampLayer()) {
            return "DocTimeStamp";
        }
        return "Sig";
    }

    protected abstract void checkDocumentPermissions(DSSDocument var1, String var2);

    @Override
    public List<PdfRevision> getRevisions(DSSDocument document, String pwd) {
        ArrayList<PdfRevision> revisions = new ArrayList<PdfRevision>();
        try (PdfDocumentReader reader = this.loadPdfDocumentReader(document, pwd);){
            PdfDssDict dssDictionary;
            PdfDssDict lastDSSDictionary = dssDictionary = reader.getDSSDictionary();
            Map<PdfSignatureDictionary, List<String>> sigDictionaries = reader.extractSigDictionaries();
            sigDictionaries = this.sortSignatureDictionaries(sigDictionaries);
            for (Map.Entry<PdfSignatureDictionary, List<String>> sigDictEntry : sigDictionaries.entrySet()) {
                PdfSignatureDictionary signatureDictionary = sigDictEntry.getKey();
                List<String> fieldNames = sigDictEntry.getValue();
                try {
                    LOG.info("Signature field name: {}", fieldNames);
                    ByteRange byteRange = signatureDictionary.getByteRange();
                    byteRange.validate();
                    byte[] cms = signatureDictionary.getContents();
                    byte[] signedContent = DSSUtils.EMPTY_BYTE_ARRAY;
                    if (!this.isContentValueEqualsByteRangeExtraction(document, byteRange, cms, fieldNames)) {
                        LOG.warn("Signature {} is skipped. SIWA detected !", fieldNames);
                    } else {
                        signedContent = PAdESUtils.getSignedContent(document, byteRange);
                    }
                    boolean signatureCoversWholeDocument = reader.isSignatureCoversWholeDocument(signatureDictionary);
                    lastDSSDictionary = this.getPreviousDssDictAndUpdateIfNeeded(revisions, lastDSSDictionary, signedContent, pwd);
                    PdfCMSRevision newRevision = null;
                    if (this.isDocTimestamp(signatureDictionary)) {
                        newRevision = new PdfDocTimestampRevision(signatureDictionary, fieldNames, signedContent, signatureCoversWholeDocument);
                    } else if (this.isSignature(signatureDictionary)) {
                        newRevision = new PdfSignatureRevision(signatureDictionary, dssDictionary, fieldNames, signedContent, signatureCoversWholeDocument);
                    } else {
                        LOG.warn("The entry {} is skipped. A signature dictionary entry with a type '{}' and subFilter '{}' is not acceptable configuration!", new Object[]{fieldNames, signatureDictionary.getType(), signatureDictionary.getSubFilter()});
                    }
                    if (newRevision != null) {
                        newRevision.setModificationDetection(this.getPdfModificationDetection(reader, signedContent, pwd));
                        revisions.add(newRevision);
                    }
                    lastDSSDictionary = this.getPreviousDssDictAndUpdateIfNeeded(revisions, lastDSSDictionary, this.extractBeforeSignatureValue(byteRange, signedContent), pwd);
                }
                catch (Exception e) {
                    String errorMessage = "Unable to parse signature {} . Reason : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.error(errorMessage, new Object[]{fieldNames, e.getMessage(), e});
                        continue;
                    }
                    LOG.error(errorMessage, fieldNames, (Object)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            throw new DSSException(String.format("The document with name [%s] is either not accessible or not PDF compatible. Reason : [%s]", document.getName(), e.getMessage()), (Throwable)e);
        }
        catch (DSSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSSException("Cannot analyze signatures : " + e.getMessage(), (Throwable)e);
        }
        return revisions;
    }

    @Override
    public DSSDocument addDssDictionary(DSSDocument document, List<DSSDictionaryCallback> callbacks) {
        return this.addDssDictionary(document, callbacks, null);
    }

    @Override
    public List<String> getAvailableSignatureFields(DSSDocument document) {
        return this.getAvailableSignatureFields(document, null);
    }

    @Override
    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters) {
        return this.addNewSignatureField(document, parameters, null);
    }

    protected abstract PdfDocumentReader loadPdfDocumentReader(DSSDocument var1, String var2) throws IOException, InvalidPasswordException;

    protected abstract PdfDocumentReader loadPdfDocumentReader(byte[] var1, String var2) throws IOException, InvalidPasswordException;

    private Map<PdfSignatureDictionary, List<String>> sortSignatureDictionaries(Map<PdfSignatureDictionary, List<String>> pdfSignatureDictionary) {
        return pdfSignatureDictionary.entrySet().stream().sorted(Map.Entry.comparingByKey(new PdfSignatureDictionaryComparator()).reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
    }

    private PdfDssDict getPreviousDssDictAndUpdateIfNeeded(List<PdfRevision> revisions, PdfDssDict lastDSSDictionary, byte[] dssDictionaryRevision, String pwd) {
        PdfDssDict currentDssDict = this.getDSSDictionaryPresentInRevision(dssDictionaryRevision, pwd);
        if (lastDSSDictionary != null && !lastDSSDictionary.equals(currentDssDict)) {
            revisions.add(new PdfDocDssRevision(lastDSSDictionary));
        }
        return currentDssDict;
    }

    private PdfDssDict getDSSDictionaryPresentInRevision(byte[] originalBytes, String pwd) {
        PdfDssDict pdfDssDict;
        block8: {
            PdfDocumentReader reader = this.loadPdfDocumentReader(originalBytes, pwd);
            try {
                pdfDssDict = reader.getDSSDictionary();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.debug("Cannot extract DSS dictionary from the previous revision : {}", (Object)e.getMessage(), (Object)e);
                    return null;
                }
            }
            reader.close();
        }
        return pdfDssDict;
    }

    protected boolean isContentValueEqualsByteRangeExtraction(DSSDocument document, ByteRange byteRange, byte[] cms, List<String> signatureFieldNames) {
        boolean match = false;
        try {
            byte[] cmsWithByteRange = this.getSignatureValue(document, byteRange);
            match = Arrays.equals(cms, cmsWithByteRange);
            if (!match) {
                LOG.warn("Conflict between /Content and ByteRange for Signature {}.", signatureFieldNames);
            }
        }
        catch (Exception e) {
            String message = String.format("Unable to retrieve data from the ByteRange : [%s]", byteRange);
            if (LOG.isDebugEnabled()) {
                LOG.debug(message, (Throwable)e);
            }
            LOG.error(message);
        }
        return match;
    }

    protected byte[] getSignatureValue(DSSDocument dssDocument, ByteRange byteRange) throws IOException {
        int startSigValueContent = byteRange.getFirstPartStart() + byteRange.getFirstPartEnd() + 1;
        int endSigValueContent = byteRange.getSecondPartStart() - 1;
        int signatureValueArraySize = endSigValueContent - startSigValueContent;
        if (signatureValueArraySize < 1) {
            throw new DSSException("The byte range present in the document is not valid! SignatureValue size cannot be negative or equal to zero!");
        }
        byte[] signatureValueArray = new byte[signatureValueArraySize];
        try (InputStream is = dssDocument.openStream();){
            DSSUtils.skipAvailableBytes((InputStream)is, (long)startSigValueContent);
            DSSUtils.readAvailableBytes((InputStream)is, (byte[])signatureValueArray);
        }
        return Utils.fromHex((String)new String(signatureValueArray));
    }

    protected byte[] extractBeforeSignatureValue(ByteRange byteRange, byte[] signedContent) {
        int length = byteRange.getFirstPartEnd();
        if (signedContent.length < length) {
            return new byte[0];
        }
        return PAdESUtils.retrievePreviousPDFRevision((DSSDocument)new InMemoryDocument(signedContent), byteRange).getBytes();
    }

    protected boolean isDocTimestamp(PdfSignatureDictionary pdfSigDict) {
        String type = pdfSigDict.getType();
        String subFilter = pdfSigDict.getSubFilter();
        return (type == null || "DocTimeStamp".equals(type)) && "ETSI.RFC3161".equals(subFilter);
    }

    protected boolean isSignature(PdfSignatureDictionary pdfSigDict) {
        String type = pdfSigDict.getType();
        String subFilter = pdfSigDict.getSubFilter();
        return (type == null || "Sig".equals(type)) && !"ETSI.RFC3161".equals(subFilter);
    }

    protected Map<String, Long> buildKnownObjects(List<DSSDictionaryCallback> callbacks) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (DSSDictionaryCallback callback : callbacks) {
            String tokenKey;
            Map.Entry<Long, CertificateToken> certEntry2;
            Map<Long, CertificateToken> storedCertificates = callback.getStoredCertificates();
            for (Map.Entry<Long, CertificateToken> certEntry2 : storedCertificates.entrySet()) {
                String tokenKey2 = this.getTokenDigest((Token)certEntry2.getValue());
                if (result.containsKey(tokenKey2)) continue;
                result.put(tokenKey2, (Long)certEntry2.getKey());
            }
            Map<Long, BasicOCSPResp> storedOcspResps = callback.getStoredOcspResps();
            certEntry2 = storedOcspResps.entrySet().iterator();
            while (certEntry2.hasNext()) {
                Map.Entry ocspEntry = (Map.Entry)certEntry2.next();
                OCSPResp ocspResp = DSSRevocationUtils.fromBasicToResp((BasicOCSPResp)((BasicOCSPResp)ocspEntry.getValue()));
                tokenKey = Utils.toBase64((byte[])DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA256, (byte[])DSSRevocationUtils.getEncoded((OCSPResp)ocspResp)));
                if (result.containsKey(tokenKey)) continue;
                result.put(tokenKey, (Long)ocspEntry.getKey());
            }
            Map<Long, CRLBinary> storedCrls = callback.getStoredCrls();
            for (Map.Entry<Long, CRLBinary> crlEntry : storedCrls.entrySet()) {
                tokenKey = Utils.toBase64((byte[])DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA256, (byte[])crlEntry.getValue().getBinaries()));
                if (result.containsKey(tokenKey)) continue;
                result.put(tokenKey, crlEntry.getKey());
            }
        }
        return result;
    }

    protected String getTokenDigest(Token token) {
        return Utils.toBase64((byte[])token.getDigest(DigestAlgorithm.SHA256));
    }

    protected void checkVisibleSignatureFieldBoxPosition(SignatureDrawer signatureDrawer, PdfDocumentReader documentReader, SignatureFieldParameters fieldParameters) throws IOException {
        AnnotationBox signatureFieldAnnotation = this.buildSignatureFieldBox(signatureDrawer);
        if (signatureFieldAnnotation != null) {
            AnnotationBox pageBox = documentReader.getPageBox(fieldParameters.getPage());
            signatureFieldAnnotation = signatureFieldAnnotation.toPdfPageCoordinates(pageBox.getHeight());
            this.checkSignatureFieldBoxOverlap(documentReader, signatureFieldAnnotation, fieldParameters.getPage());
        }
    }

    protected AnnotationBox buildSignatureFieldBox(SignatureDrawer signatureDrawer) throws IOException {
        SignatureFieldBoxBuilder signatureFieldBoxBuilder;
        VisualSignatureFieldAppearance signatureFieldBox;
        if (signatureDrawer instanceof SignatureFieldBoxBuilder && (signatureFieldBox = (signatureFieldBoxBuilder = (SignatureFieldBoxBuilder)((Object)signatureDrawer)).buildSignatureFieldBox()) != null) {
            return signatureFieldBox.getAnnotationBox();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("The used SignatureDrawer shall be an instance of VisibleSignatureFieldBoxBuilder in order to verify a SignatureField position!");
        }
        return null;
    }

    protected AnnotationBox checkVisibleSignatureFieldBoxPosition(PdfDocumentReader reader, SignatureFieldParameters parameters) throws IOException {
        AnnotationBox annotationBox = new AnnotationBox(parameters);
        AnnotationBox pageBox = reader.getPageBox(parameters.getPage());
        annotationBox = annotationBox.toPdfPageCoordinates(pageBox.getHeight());
        this.checkSignatureFieldBoxOverlap(reader, annotationBox, parameters.getPage());
        return annotationBox;
    }

    private void checkSignatureFieldBoxOverlap(PdfDocumentReader reader, AnnotationBox signatureFieldBox, int page) throws IOException {
        List<PdfAnnotation> pdfAnnotations = reader.getPdfAnnotations(page);
        if (PdfModificationDetectionUtils.isAnnotationBoxOverlapping(signatureFieldBox, pdfAnnotations)) {
            this.alertOnSignatureFieldOverlap();
        }
    }

    private void alertOnSignatureFieldOverlap() {
        String alertMessage = "The new signature field position overlaps with an existing annotation!";
        this.alertOnSignatureFieldOverlap.alert((Object)new Status(alertMessage));
    }

    protected PdfModificationDetection getPdfModificationDetection(PdfDocumentReader finalRevisionReader, byte[] signedContent, String pwd) {
        PdfModificationDetectionImpl pdfModificationDetectionImpl;
        block10: {
            PdfDocumentReader signedRevisionReader = this.loadPdfDocumentReader((DSSDocument)new InMemoryDocument(signedContent), pwd);
            try {
                PdfModificationDetectionImpl pdfModificationDetection = new PdfModificationDetectionImpl();
                pdfModificationDetection.setAnnotationOverlaps(PdfModificationDetectionUtils.getAnnotationOverlaps(finalRevisionReader));
                pdfModificationDetection.setPageDifferences(PdfModificationDetectionUtils.getPagesDifferences(signedRevisionReader, finalRevisionReader));
                pdfModificationDetection.setVisualDifferences(this.getVisualDifferences(signedRevisionReader, finalRevisionReader));
                pdfModificationDetectionImpl = pdfModificationDetection;
                if (signedRevisionReader == null) break block10;
            }
            catch (Throwable pdfModificationDetection) {
                try {
                    if (signedRevisionReader != null) {
                        try {
                            signedRevisionReader.close();
                        }
                        catch (Throwable throwable) {
                            pdfModificationDetection.addSuppressed(throwable);
                        }
                    }
                    throw pdfModificationDetection;
                }
                catch (Exception e) {
                    String errorMessage = "Unable to proceed PDF modification detection. Reason : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.error(errorMessage, (Object)e.getMessage(), (Object)e);
                    } else {
                        LOG.error(errorMessage, (Object)e.getMessage());
                    }
                    return null;
                }
            }
            signedRevisionReader.close();
        }
        return pdfModificationDetectionImpl;
    }

    protected List<PdfModification> getVisualDifferences(PdfDocumentReader signedRevisionReader, PdfDocumentReader finalRevisionReader) throws IOException {
        int pagesAmount = finalRevisionReader.getNumberOfPages();
        if (this.maximalPagesAmountForVisualComparison >= pagesAmount) {
            return PdfModificationDetectionUtils.getVisualDifferences(signedRevisionReader, finalRevisionReader);
        }
        LOG.debug("The provided document contains {} pages, while the limit for a visual comparison is set to {}.", (Object)pagesAmount, (Object)this.maximalPagesAmountForVisualComparison);
        return Collections.emptyList();
    }
}

