/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.pades.validation.PdfModificationDetection;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.validation.ByteRange;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSSignedData;

public abstract class PdfCMSRevision
implements PdfRevision {
    private final PdfSignatureDictionary signatureDictionary;
    private final byte[] signedContent;
    private final boolean coverAllOriginalBytes;
    private final List<String> signatureFieldNames;
    private PdfModificationDetection modificationDetection;

    protected PdfCMSRevision(PdfSignatureDictionary signatureDictionary, List<String> signatureFieldNames, byte[] signedContent, boolean coverAllOriginalBytes) {
        Objects.requireNonNull(signatureDictionary, "The signature dictionary cannot be null!");
        Objects.requireNonNull(signatureFieldNames, "The signature field names must be defined!");
        Objects.requireNonNull(signedContent, "The signed content cannot be null!");
        this.signatureDictionary = signatureDictionary;
        this.signatureFieldNames = signatureFieldNames;
        this.signedContent = signedContent;
        this.coverAllOriginalBytes = coverAllOriginalBytes;
    }

    public byte[] getRevisionCoveredBytes() {
        return this.signedContent;
    }

    @Override
    public PdfSignatureDictionary getPdfSigDictInfo() {
        return this.signatureDictionary;
    }

    public ByteRange getByteRange() {
        return this.signatureDictionary.getByteRange();
    }

    public Date getSigningDate() {
        return this.signatureDictionary.getSigningDate();
    }

    public boolean areAllOriginalBytesCovered() {
        return this.coverAllOriginalBytes;
    }

    @Override
    public List<String> getFieldNames() {
        return this.signatureFieldNames;
    }

    public CMSSignedData getCMSSignedData() {
        return this.signatureDictionary.getCMSSignedData();
    }

    @Override
    public PdfModificationDetection getModificationDetection() {
        return this.modificationDetection;
    }

    public void setModificationDetection(PdfModificationDetection modificationDetection) {
        this.modificationDetection = modificationDetection;
    }
}

