/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pades.validation.timestamp.PdfTimestampToken;
import eu.europa.esig.dss.pdf.PdfCMSRevision;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfDocTimestampRevision
extends PdfCMSRevision {
    private static final Logger LOG = LoggerFactory.getLogger(PdfDocTimestampRevision.class);
    private final TimestampToken timestampToken;

    public PdfDocTimestampRevision(PdfSignatureDictionary signatureDictionary, List<String> timestampFieldNames, byte[] signedContent, boolean coverCompleteRevision) {
        super(signatureDictionary, timestampFieldNames, signedContent, coverCompleteRevision);
        try {
            this.timestampToken = new PdfTimestampToken(this);
            this.timestampToken.matchData((DSSDocument)new InMemoryDocument(this.getRevisionCoveredBytes()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created PdfDocTimestampInfo : {}", (Object)this.getByteRange());
            }
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    @Override
    public Date getSigningDate() {
        return this.timestampToken.getGenerationTime();
    }

    public TimestampToken getTimestampToken() {
        return this.timestampToken;
    }
}

