/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.validation.ByteRange;
import java.io.IOException;
import java.util.Date;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;

public class PdfSigDictWrapper
implements PdfSignatureDictionary {
    private final PdfDict dictionary;
    private final CMSSignedData cmsSignedData;
    private final ByteRange byteRange;

    public PdfSigDictWrapper(PdfDict dictionary) {
        this.dictionary = dictionary;
        this.cmsSignedData = this.buildCMSSignedData();
        this.byteRange = this.buildByteRange();
    }

    private CMSSignedData buildCMSSignedData() {
        try {
            return new CMSSignedData(this.getContents());
        }
        catch (CMSException e) {
            throw new DSSException("Unable to build an instance of CMSSignedData", (Throwable)e);
        }
    }

    private ByteRange buildByteRange() {
        PdfArray byteRangeArray = this.dictionary.getAsArray("ByteRange");
        if (byteRangeArray == null) {
            throw new DSSException("Unable to retrieve the ByteRange");
        }
        int arraySize = byteRangeArray.size();
        int[] result = new int[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            try {
                result[i] = byteRangeArray.getInt(i);
                continue;
            }
            catch (IOException e) {
                throw new DSSException("Unable to parse integer from the ByteRange", (Throwable)e);
            }
        }
        return new ByteRange(result);
    }

    @Override
    public String getSignerName() {
        return this.dictionary.getStringValue("Name");
    }

    @Override
    public String getContactInfo() {
        return this.dictionary.getStringValue("ContactInfo");
    }

    @Override
    public String getReason() {
        return this.dictionary.getStringValue("Reason");
    }

    @Override
    public String getLocation() {
        return this.dictionary.getStringValue("Location");
    }

    @Override
    public Date getSigningDate() {
        return this.dictionary.getDateValue("M");
    }

    @Override
    public String getType() {
        return this.dictionary.getNameValue("Type");
    }

    @Override
    public String getFilter() {
        return this.dictionary.getNameValue("Filter");
    }

    @Override
    public String getSubFilter() {
        return this.dictionary.getNameValue("SubFilter");
    }

    @Override
    public CMSSignedData getCMSSignedData() {
        return this.cmsSignedData;
    }

    @Override
    public byte[] getContents() {
        try {
            return this.dictionary.getBinariesValue("Contents");
        }
        catch (IOException e) {
            throw new DSSException("Unable to retrieve the signature content", (Throwable)e);
        }
    }

    @Override
    public ByteRange getByteRange() {
        return this.byteRange;
    }
}

