/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.visible;

import eu.europa.esig.dss.pdf.AnnotationBox;

public abstract class AbstractFontMetrics {
    public String[] getLines(String text) {
        return text.split("\\r?\\n");
    }

    public AnnotationBox computeTextBoundaryBox(String text, float fontSize, float padding) {
        String[] lines = this.getLines(text);
        float width = 0.0f;
        for (String line : lines) {
            float lineWidth = this.getWidth(line, fontSize);
            if (!(lineWidth > width)) continue;
            width = lineWidth;
        }
        float doublePadding = padding * 2.0f;
        float strHeight = this.getHeight(text, fontSize);
        float height = strHeight * (float)lines.length + doublePadding;
        return new AnnotationBox(0.0f, 0.0f, width += doublePadding, height);
    }

    public abstract float getWidth(String var1, float var2);

    public abstract float getHeight(String var1, float var2);
}

