/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.visible;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pdf.visible.CommonDrawerUtils;
import java.io.InputStream;

public class ImageAndResolution {
    private int xDpi;
    private int yDpi;
    private DSSDocument image;

    public ImageAndResolution(DSSDocument image, int xDpi, int yDpi) {
        this.xDpi = xDpi;
        this.yDpi = yDpi;
        this.image = image;
    }

    public int getxDpi() {
        return this.xDpi;
    }

    public int getyDpi() {
        return this.yDpi;
    }

    public float toXPoint(float x) {
        return CommonDrawerUtils.toDpiAxisPoint(x, this.xDpi);
    }

    public float toYPoint(float y) {
        return CommonDrawerUtils.toDpiAxisPoint(y, this.yDpi);
    }

    public String toString() {
        return "Resolution [xDpi=" + this.xDpi + ", yDpi=" + this.yDpi + "]";
    }

    public InputStream getInputStream() {
        return this.image.openStream();
    }
}

