/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineT;
import eu.europa.esig.dss.pades.validation.PDFDocumentValidator;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationDataContainer;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.List;

class PAdESLevelBaselineLT
extends PAdESLevelBaselineT {
    private final CertificateVerifier certificateVerifier;

    PAdESLevelBaselineLT(TSPSource tspSource, CertificateVerifier certificateVerifier, IPdfObjFactory pdfObjectFactory) {
        super(tspSource, pdfObjectFactory);
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public DSSDocument extendSignatures(DSSDocument document, PAdESSignatureParameters parameters) {
        this.assertExtensionPossible(document);
        PDFDocumentValidator pdfDocumentValidator = this.getPDFDocumentValidator(document, parameters);
        List<AdvancedSignature> signatures = pdfDocumentValidator.getSignatures();
        if (Utils.isCollectionEmpty(signatures)) {
            throw new IllegalInputException("No signatures found to be extended!");
        }
        for (AdvancedSignature signature : signatures) {
            if (!this.requiresDocumentTimestamp(signature)) continue;
            document = super.extendSignatures(document, parameters);
            pdfDocumentValidator = this.getPDFDocumentValidator(document, parameters);
            break;
        }
        signatures = pdfDocumentValidator.getSignatures();
        this.assertExtendSignaturePossible(signatures);
        List<TimestampToken> detachedTimestamps = pdfDocumentValidator.getDetachedTimestamps();
        ValidationDataContainer validationData = pdfDocumentValidator.getValidationData(signatures, detachedTimestamps);
        PDFSignatureService signatureService = this.newPdfSignatureService();
        return signatureService.addDssDictionary(document, validationData, parameters.getPasswordProtection());
    }

    private PDFDocumentValidator getPDFDocumentValidator(DSSDocument document, PAdESSignatureParameters parameters) {
        PDFDocumentValidator pdfDocumentValidator = new PDFDocumentValidator(document);
        pdfDocumentValidator.setCertificateVerifier(this.certificateVerifier);
        pdfDocumentValidator.setPasswordProtection(parameters.getPasswordProtection());
        if (this.pdfObjectFactory != null) {
            pdfDocumentValidator.setPdfObjFactory(this.pdfObjectFactory);
        }
        return pdfDocumentValidator;
    }

    private boolean requiresDocumentTimestamp(AdvancedSignature signature) {
        ArrayList timestamps = new ArrayList(signature.getSignatureTimestamps());
        timestamps.addAll(signature.getArchiveTimestamps());
        timestamps.addAll(signature.getDocumentTimestamps());
        return Utils.isCollectionEmpty(timestamps);
    }

    private void assertExtendSignaturePossible(List<AdvancedSignature> signatures) {
        for (AdvancedSignature signature : signatures) {
            if (!signature.areAllSelfSignedCertificates()) continue;
            throw new IllegalInputException("Cannot extend the signature. The signature contains only self-signed certificate chains!");
        }
    }
}

