/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.PAdESTimestampParameters;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.timestamp.PAdESTimestampService;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;

class PAdESLevelBaselineT
implements SignatureExtension<PAdESSignatureParameters> {
    private final TSPSource tspSource;
    protected final IPdfObjFactory pdfObjectFactory;

    protected PAdESLevelBaselineT(TSPSource tspSource, IPdfObjFactory pdfObjectFactory) {
        this.tspSource = tspSource;
        this.pdfObjectFactory = pdfObjectFactory;
    }

    public DSSDocument extendSignatures(DSSDocument document, PAdESSignatureParameters params) {
        this.assertExtensionPossible(document);
        return this.timestampDocument(document, params.getSignatureTimestampParameters(), params.getPasswordProtection());
    }

    protected DSSDocument timestampDocument(DSSDocument document, PAdESTimestampParameters timestampParameters, String pwd) {
        PAdESTimestampService padesTimestampService = new PAdESTimestampService(this.tspSource, this.newPdfSignatureService());
        timestampParameters.setPasswordProtection(pwd);
        return padesTimestampService.timestampDocument(document, timestampParameters);
    }

    protected PDFSignatureService newPdfSignatureService() {
        return this.pdfObjectFactory.newSignatureTimestampService();
    }

    protected void assertExtensionPossible(DSSDocument document) {
        if (!PAdESUtils.isPDFDocument(document)) {
            throw new IllegalInputException(String.format("Unable to extend the document with name '%s'. PDF document is expected!", document.getName()));
        }
    }
}

