/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESBaselineRequirementsChecker;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pades.validation.timestamp.PdfTimestampToken;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESBaselineRequirementsChecker
extends CAdESBaselineRequirementsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESBaselineRequirementsChecker.class);
    private static final String CONTENT_TYPE_ID_DATA = "1.2.840.113549.1.7.1";

    public PAdESBaselineRequirementsChecker(PAdESSignature signature, CertificateVerifier offlineCertificateVerifier) {
        super((CAdESSignature)signature, offlineCertificateVerifier);
    }

    protected SignatureForm getBaselineSignatureForm() {
        return SignatureForm.PAdES;
    }

    public boolean hasBaselineBProfile() {
        if (!this.cmsBaselineBRequirements()) {
            return false;
        }
        PAdESSignature padesSignature = (PAdESSignature)this.signature;
        PdfSignatureDictionary pdfSignatureDictionary = padesSignature.getPdfSignatureDictionary();
        if (pdfSignatureDictionary.getSigningDate() == null) {
            LOG.warn("Entry with the key M in the Signature Dictionary shall be present for PAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (Utils.isArrayEmpty((byte[])pdfSignatureDictionary.getContents())) {
            LOG.warn("Entry with the key Contents in the Signature Dictionary shall be present for PAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (Utils.isStringEmpty((String)pdfSignatureDictionary.getFilter())) {
            LOG.warn("Entry with the key Filter in the Signature Dictionary shall be present for PAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (pdfSignatureDictionary.getByteRange() == null) {
            LOG.warn("Entry with the key ByteRange in the Signature Dictionary shall be present for PAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (Utils.isStringEmpty((String)pdfSignatureDictionary.getSubFilter())) {
            LOG.warn("Entry with the key SubFilter in the Signature Dictionary shall be present for PAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (!CONTENT_TYPE_ID_DATA.equals(padesSignature.getContentType())) {
            LOG.warn("content-type attribute shall have value id-data for PAdES-BASELINE-B signature! (requirement (c))");
            return false;
        }
        if (Utils.isStringNotEmpty((String)pdfSignatureDictionary.getReason()) && Utils.isCollectionNotEmpty((Collection)padesSignature.getCommitmentTypeIndications())) {
            LOG.warn("commitment-type-indication attribute shall not be incorporated in the CMS signature when entry with a key Reason is used for PAdES-BASELINE-B signature! (requirement (d))");
            return false;
        }
        if (!"ETSI.CAdES.detached".equals(pdfSignatureDictionary.getSubFilter())) {
            LOG.warn("Entry with a key SubFilter shall contain a value ETSI.CAdES.detached for PAdES-BASELINE-B signature! (requirement (l))");
            return false;
        }
        if ((Utils.isCollectionNotEmpty((Collection)padesSignature.getCommitmentTypeIndications()) || padesSignature.getSignaturePolicy() != null) && Utils.isStringNotEmpty((String)pdfSignatureDictionary.getReason())) {
            LOG.warn("Entry with a key Reason shall not be used when commitment-type-attribute or signature-policy-identifier is present in the CMS signature for PAdES-BASELINE-B signature! (requirement (m))");
            return false;
        }
        return true;
    }

    public boolean hasBaselineTProfile() {
        if (Utils.isCollectionEmpty((Collection)((CAdESSignature)this.signature).getSignatureTimestamps()) && Utils.isCollectionEmpty((Collection)((CAdESSignature)this.signature).getDocumentTimestamps())) {
            LOG.trace("SignatureTimeStamp shall be present for BASELINE-T signature (cardinality >= 1)!");
            return false;
        }
        return true;
    }

    public boolean hasBaselineLTProfile() {
        if (!this.minimalLTRequirement()) {
            return false;
        }
        PAdESSignature padesSignature = (PAdESSignature)this.signature;
        boolean allSelfSigned = padesSignature.getCertificateSource().isAllSelfSigned();
        if (!allSelfSigned && padesSignature.getDssDictionary() == null) {
            LOG.warn("DSS dictionary shall be present for PAdES-BASELINE-LT signature! (cardinality >= 1)");
            return false;
        }
        return true;
    }

    public boolean hasBaselineLTAProfile() {
        boolean ltaTimestampFound = false;
        for (TimestampToken timestampToken : ((CAdESSignature)this.signature).getDocumentTimestamps()) {
            if (!this.isBaselineLTATimestamp(timestampToken)) continue;
            ltaTimestampFound = true;
            break;
        }
        if (!ltaTimestampFound) {
            LOG.debug("document-time-stamp covering LT-level and containing a key SubFilter with value ETSI.RFC3161 shall be present for PAdES-BASELINE-LTA signature! (cardinality >= 1, requirement (y))");
            return false;
        }
        return true;
    }

    private boolean isBaselineLTATimestamp(TimestampToken timestampToken) {
        return this.coversLTLevelData(timestampToken) && this.containsRFC3161SubFilter(timestampToken);
    }

    private boolean coversLTLevelData(TimestampToken timestampToken) {
        return ArchiveTimestampType.PAdES.equals((Object)timestampToken.getArchiveTimestampType());
    }

    private boolean containsRFC3161SubFilter(TimestampToken timestampToken) {
        PdfSignatureDictionary pdfSigDictInfo;
        PdfDocTimestampRevision pdfRevision;
        return timestampToken instanceof PdfTimestampToken && (pdfRevision = ((PdfTimestampToken)timestampToken).getPdfRevision()) != null && (pdfSigDictInfo = pdfRevision.getPdfSigDictInfo()) != null && "ETSI.RFC3161".equals(pdfSigDictInfo.getSubFilter());
    }

    public boolean hasPKCS7Profile() {
        PAdESSignature padesSignature = (PAdESSignature)this.signature;
        PdfSignatureDictionary pdfSignatureDictionary = padesSignature.getPdfSignatureDictionary();
        if (!"adbe.pkcs7.detached".equals(pdfSignatureDictionary.getSubFilter()) && !"adbe.pkcs7.sha1".equals(pdfSignatureDictionary.getSubFilter())) {
            LOG.debug("Entry with a key SubFilter shall have a value adbe.pkcs7.detached or adbe.pkcs7.sha1 for PKCS#7 signature!");
            return false;
        }
        if (!this.containsSigningCertificate(padesSignature.getCertificateSource().getCertificates())) {
            LOG.warn("PKCS#7 signature shall include signing certificate!");
            return false;
        }
        return true;
    }

    public boolean hasPKCS7TProfile() {
        return this.hasBaselineTProfile();
    }

    public boolean hasPKCS7LTProfile() {
        return this.minimalLTRequirement();
    }

    public boolean hasPKCS7LTAProfile() {
        boolean ltaTimestampFound = false;
        for (TimestampToken timestampToken : ((CAdESSignature)this.signature).getDocumentTimestamps()) {
            if (!this.coversLTLevelData(timestampToken)) continue;
            ltaTimestampFound = true;
            break;
        }
        if (!ltaTimestampFound) {
            LOG.debug("document-time-stamp covering LT-level shall be present for PKCS#7-LTA signature!");
            return false;
        }
        return true;
    }
}

