/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.PdfDssDictCRLSource;
import eu.europa.esig.dss.pades.validation.RevocationInfoArchival;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x509.CertificateList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESCRLSource
extends PdfDssDictCRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESCRLSource.class);
    private final String vriDictionaryName;

    public PAdESCRLSource(PdfDssDict dssDictionary, String vriDictionaryName, AttributeTable signedAttributes) {
        Objects.requireNonNull(vriDictionaryName, "vriDictionaryName cannot be null!");
        this.vriDictionaryName = vriDictionaryName;
        this.extractDSSCRLs(dssDictionary);
        this.extractVRICRLs(dssDictionary);
        this.extractCRLArchivalValues(signedAttributes);
    }

    private void extractCRLArchivalValues(AttributeTable signedAttributes) {
        ASN1Encodable attValue;
        RevocationInfoArchival revValues;
        if (signedAttributes != null && (revValues = PAdESUtils.getRevocationInfoArchival(attValue = DSSASN1Utils.getAsn1Encodable((AttributeTable)signedAttributes, (ASN1ObjectIdentifier)OID.adbe_revocationInfoArchival))) != null) {
            for (CertificateList revValue : revValues.getCrlVals()) {
                try {
                    this.addBinary((EncapsulatedRevocationTokenIdentifier)CRLUtils.buildCRLBinary((byte[])revValue.getEncoded()), RevocationOrigin.ADBE_REVOCATION_INFO_ARCHIVAL);
                }
                catch (Exception e) {
                    LOG.warn("Could not convert CertificateList to CRLBinary : {}", (Object)e.getMessage());
                }
            }
        }
    }

    @Override
    protected void extractVRICRLs(PdfVRIDict vriDictionary) {
        if (vriDictionary != null && this.vriDictionaryName.equals(vriDictionary.getName())) {
            super.extractVRICRLs(vriDictionary);
        }
    }
}

