/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.PdfDssDictOCSPSource;
import eu.europa.esig.dss.pades.validation.RevocationInfoArchival;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESOCSPSource
extends PdfDssDictOCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESOCSPSource.class);
    private final String vriDictionaryName;

    public PAdESOCSPSource(PdfDssDict dssDictionary, String vriDictionaryName, AttributeTable signedAttributes) {
        Objects.requireNonNull(vriDictionaryName, "vriDictionaryName cannot be null!");
        this.vriDictionaryName = vriDictionaryName;
        this.extractDSSOCSPs(dssDictionary);
        this.extractVRIOCSPs(dssDictionary);
        this.extractOCSPArchivalValues(signedAttributes);
    }

    private void extractOCSPArchivalValues(AttributeTable signedAttributes) {
        RevocationInfoArchival revocationArchival;
        ASN1Encodable attValue;
        if (signedAttributes != null && (attValue = DSSASN1Utils.getAsn1Encodable((AttributeTable)signedAttributes, (ASN1ObjectIdentifier)OID.adbe_revocationInfoArchival)) != null && (revocationArchival = PAdESUtils.getRevocationInfoArchival(attValue)) != null) {
            for (OCSPResponse ocspResponse : revocationArchival.getOcspVals()) {
                try {
                    BasicOCSPResp basicOCSPResponse = DSSASN1Utils.toBasicOCSPResp((OCSPResponse)ocspResponse);
                    this.addBinary((EncapsulatedRevocationTokenIdentifier)OCSPResponseBinary.build((BasicOCSPResp)basicOCSPResponse), RevocationOrigin.ADBE_REVOCATION_INFO_ARCHIVAL);
                }
                catch (OCSPException e) {
                    LOG.warn("Error while extracting OCSPResponse from Revocation Info Archivals (ADBE) : {}", (Object)e.getMessage());
                }
            }
        }
    }

    @Override
    protected void extractVRIOCSPs(PdfVRIDict vriDictionary) {
        if (vriDictionary != null && this.vriDictionaryName.equals(vriDictionary.getName())) {
            super.extractVRIOCSPs(vriDictionary);
        }
    }
}

