/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PdfDssDictCRLSource
extends OfflineCRLSource {
    private static final long serialVersionUID = 7920126699012690199L;
    private transient Map<Long, CRLBinary> crlMap;

    public PdfDssDictCRLSource(PdfDssDict dssDictionary) {
        this.extractDSSCRLs(dssDictionary);
        this.extractVRICRLs(dssDictionary);
    }

    PdfDssDictCRLSource() {
    }

    public Map<Long, CRLBinary> getCrlMap() {
        if (this.crlMap != null) {
            return this.crlMap;
        }
        return Collections.emptyMap();
    }

    private Map<Long, CRLBinary> getDssCrlMap(PdfDssDict dssDictionary) {
        if (dssDictionary != null) {
            this.crlMap = dssDictionary.getCRLs();
            return this.crlMap;
        }
        return Collections.emptyMap();
    }

    protected void extractDSSCRLs(PdfDssDict dssDictionary) {
        Map<Long, CRLBinary> dssCrlMap = this.getDssCrlMap(dssDictionary);
        for (CRLBinary crl : dssCrlMap.values()) {
            this.addBinary((EncapsulatedRevocationTokenIdentifier)crl, RevocationOrigin.DSS_DICTIONARY);
        }
    }

    protected void extractVRICRLs(PdfDssDict dssDictionary) {
        if (dssDictionary != null) {
            List<PdfVRIDict> vriDictList = dssDictionary.getVRIs();
            for (PdfVRIDict vriDict : vriDictList) {
                this.extractVRICRLs(vriDict);
            }
        }
    }

    protected void extractVRICRLs(PdfVRIDict vriDictionary) {
        if (vriDictionary != null) {
            for (Map.Entry<Long, CRLBinary> crlEntry : vriDictionary.getCRLs().entrySet()) {
                if (!this.crlMap.containsKey(crlEntry.getKey())) {
                    this.crlMap.put(crlEntry.getKey(), crlEntry.getValue());
                }
                this.addBinary((EncapsulatedRevocationTokenIdentifier)crlEntry.getValue(), RevocationOrigin.VRI_DICTIONARY);
            }
        }
    }
}

